/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.Extent;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.porttype.Resource;
import org.gcube.datatransfer.scheduler.impl.porttype.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.porttype.StatefulContext;
import org.gcube.datatransfer.scheduler.is.ISManager;
import org.gcube.datatransfer.scheduler.library.InfoCancelSchedulerMessage;
import org.gcube.datatransfer.scheduler.library.InfoSchedulerMessage;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.TransferType;
import org.globus.wsrf.ResourceException;

public class Stateful
extends GCUBEPortType {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    public DataTransferDBManager dbManager;
    public ISManager isManager;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String visit(VOID void_type) throws GCUBEFault {
        ServiceContext sctx = ServiceContext.getContext();
        Resource resource = null;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            System.out.println("Stateful - visit - Exception in retrieving the resource");
            e1.printStackTrace();
            return null;
        }
        try {
            StringBuilder output = new StringBuilder();
            GHNContext nctx = GHNContext.getContext();
            GCUBEStatefulPortTypeContext pctx = StatefulContext.getContext();
            resource.addVisit();
            output.append("Stateful - Hello " + resource.getName()).append("\nyou have invoked porttype ").append(String.valueOf(pctx.getName()) + " \nof service " + sctx.getName() + ", which you found at:\n").append(pctx.getEPR() + "in the gCube infrastructure " + nctx.getGHN().getInfrastructure()).append(" and you are in the Scope " + sctx.getScope()).append(" \nThis is your invocation N." + resource.getVisits() + "\n");
            resource.store();
            return output.toString();
        }
        catch (GCUBEException e) {
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            throw sctx.getDefaultException(e).toFault(new String[0]);
        }
    }

    public String storeInfoScheduler(String msg) throws GCUBEFault {
        Iterator iter;
        String[] inputURIs;
        ServiceContext sctx = ServiceContext.getContext();
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManager = new ISManager(this.dbManager);
        try {
            Resource resource = this.getResource();
            resource.setSchedulerMessage(msg);
            resource.store();
        }
        catch (Exception e) {
            throw sctx.getDefaultException(e).toFault(new String[0]);
        }
        InfoSchedulerMessage infoObj = new InfoSchedulerMessage();
        String transferId = uuidgen.nextUUID();
        Transfer t = new Transfer();
        t.setTransferId(transferId);
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        infoObj = (InfoSchedulerMessage)xstream.fromXML(tmpMsg);
        try {
            t.setSubmitter(this.getResource().getName());
        }
        catch (ResourceException e1) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in setting the submitter in Transfer:\n");
            e1.printStackTrace();
        }
        t.setStatus("STANDBY");
        TypeOfSchedule typeOfSchedule = new TypeOfSchedule();
        typeOfSchedule.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
        if (infoObj.getTypeOfSchedule().isDirectedScheduled()) {
            typeOfSchedule.setDirectedScheduled(true);
        } else if (infoObj.getTypeOfSchedule().getManuallyScheduled() != null) {
            ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
            manuallyScheduled.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
            manuallyScheduled.setCalendar(infoObj.getTypeOfSchedule().getManuallyScheduled().getCalendar());
            try {
                typeOfSchedule.setManuallyScheduledId(manuallyScheduled.getManuallyScheduledId());
                ServiceContext.getContext().getDbManager().storeManuallyScheduled(manuallyScheduled);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the ManuallyScheduled:\n");
                e.printStackTrace();
            }
        } else if (infoObj.getTypeOfSchedule().getPeriodicallyScheduled() != null) {
            PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
            periodicallyScheduled.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
            periodicallyScheduled.setFrequency(infoObj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency());
            periodicallyScheduled.setStartInstance(infoObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance());
            try {
                typeOfSchedule.setPeriodicallyScheduledId(periodicallyScheduled.getPeriodicallyScheduledId());
                ServiceContext.getContext().getDbManager().storePeriodicallyScheduled(periodicallyScheduled);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the PeriodicallyScheduled:\n");
                e.printStackTrace();
            }
        }
        try {
            t.setTypeOfScheduleId(typeOfSchedule.getTypeOfScheduleId());
            ServiceContext.getContext().getDbManager().storeTypeOfSchedule(typeOfSchedule);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the TypeOfSchedule:\n");
            e.printStackTrace();
        }
        DataSource datasource = new DataSource();
        datasource.setDataSourceId(transferId.concat("-datasource"));
        TransferType transferType = infoObj.getStartTransferMessage().getSource().getType();
        datasource.setType(transferType.getValue());
        try {
            t.setSourceId(datasource.getDataSourceId());
            ServiceContext.getContext().getDbManager().storeSource(datasource);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeSource) - Exception in storing the DataSource:\n");
            e.printStackTrace();
        }
        Agent agent = new Agent();
        agent.setAgentId(transferId.concat("-agent"));
        agent.setHost("pcitgt1012.cern.ch");
        agent.setPort(8080);
        try {
            ServiceContext.getContext().getDbManager().storeAgent(agent);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the Agent:\n");
            e.printStackTrace();
        }
        t.setAgentId(transferId.concat("-agent"));
        if (transferType == TransferType.LocalFileBasedTransfer) {
            inputURIs = infoObj.getStartTransferMessage().getSource().getInputURIs();
            String destinationFolder = infoObj.getStartTransferMessage().getDest().getOutUri().getOutUris()[0].toString();
            boolean overwrite = infoObj.getStartTransferMessage().getDest().getOutUri().isOverwrite();
            TransferObject obj = null;
            String[] stringArray = inputURIs;
            int n = inputURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String inputUrl = stringArray[n2];
                obj = new TransferObject();
                obj.setURI(inputUrl);
                obj.setTransferid(transferId);
                transferObjects.add(obj);
                ++n2;
            }
            DataStorage datastorage = new DataStorage();
            datastorage.setDataStorageId(transferId.concat("-datastorage"));
            datastorage.setOutputUrl(destinationFolder);
            datastorage.setOverwrite(overwrite);
            try {
                t.setStorageId(datastorage.getDataStorageId());
                ServiceContext.getContext().getDbManager().storeStorage(datastorage);
            }
            catch (Exception e) {
                System.out.println("Stateful Service(storeStorage) - Exception in storing the DataStorage:\n");
                e.printStackTrace();
            }
        } else if (transferType == TransferType.FileBasedTransfer) {
            DataStorage datastorage;
            inputURIs = infoObj.getStartTransferMessage().getSource().getInputURIs();
            StorageType storageType = infoObj.getStartTransferMessage().getDest().getOutUri().getStorageType();
            String destinationFolder = infoObj.getStartTransferMessage().getDest().getOutUri().getOutUris()[0].toString();
            boolean overwrite = infoObj.getStartTransferMessage().getDest().getOutUri().isOverwrite();
            TransferObject obj = null;
            String[] stringArray = inputURIs;
            int n = inputURIs.length;
            int n3 = 0;
            while (n3 < n) {
                String inputUrl = stringArray[n3];
                obj = new TransferObject();
                obj.setURI(inputUrl);
                obj.setTransferid(transferId);
                transferObjects.add(obj);
                ++n3;
            }
            if (storageType.getValue() == StorageType.LocalGHN.getValue()) {
                datastorage = new DataStorage();
                datastorage.setDataStorageId(transferId.concat("-datastorage"));
                datastorage.setOutputUrl(destinationFolder);
                datastorage.setOverwrite(overwrite);
                datastorage.setType(StorageType.LocalGHN.getValue());
                try {
                    t.setStorageId(datastorage.getDataStorageId());
                    ServiceContext.getContext().getDbManager().storeStorage(datastorage);
                }
                catch (Exception e) {
                    System.out.println("Stateful Service(storeStorage) - Exception in storing the DataStorage:\n");
                    e.printStackTrace();
                }
            } else if (storageType.getValue() == StorageType.StorageManager.getValue()) {
                datastorage = new DataStorage();
                datastorage.setDataStorageId(transferId.concat("-datastorage"));
                datastorage.setOutputUrl(destinationFolder);
                datastorage.setOverwrite(overwrite);
                datastorage.setType(StorageType.StorageManager.getValue());
                try {
                    t.setStorageId(datastorage.getDataStorageId());
                    ServiceContext.getContext().getDbManager().storeStorage(datastorage);
                }
                catch (Exception e) {
                    System.out.println("Stateful Service(storeStorage) - Exception in storing the DataStorage:\n");
                    e.printStackTrace();
                }
            }
        }
        try {
            ServiceContext.getContext().getDbManager().storeTransfer(t);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the Transfer:\n");
            e.printStackTrace();
        }
        try {
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
        }
        catch (Exception e) {
            System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the Set of Transfer Objects:\n");
            e.printStackTrace();
        }
        try {
            Extent transferExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(Transfer.class, true);
            iter = transferExtent.iterator();
            System.out.println("\nStateful Service(storeInfoScheduler) - Retrieve all the Transfers by method:\n");
            while (iter.hasNext()) {
                Object obj = iter.next();
                System.out.println("TransferId=" + ((Transfer)obj).getTransferId() + " -- Status=" + ((Transfer)obj).getStatus() + " -- Submitter=" + ((Transfer)obj).getSubmitter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
        try {
            Extent transferobjExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(TransferObject.class, true);
            iter = transferobjExtent.iterator();
            System.out.println("\nStateful Service(storeInfoScheduler) - Retrieve all the TransferObjects (files) by method:\n");
            while (iter.hasNext()) {
                Object obj = iter.next();
                System.out.println("TransferObjId=" + ((TransferObject)obj).getObjectId() + " -- transferid=" + ((TransferObject)obj).getTransferid());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
        return transferId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String cancelScheduledTransfer(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManager = new ISManager(this.dbManager);
        String error = new String("Error: ");
        String tmpMsg = msg;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        InfoCancelSchedulerMessage cancelObj = new InfoCancelSchedulerMessage();
        cancelObj = (InfoCancelSchedulerMessage)xstream.fromXML(tmpMsg);
        String transferId = cancelObj.getCancelTransferMessage().getTransferID();
        Boolean isForceCancel = cancelObj.getCancelTransferMessage().isForceStop();
        Transfer transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String typeOfScheduleId = transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)typeOfScheduleId);
        String agentId = transfer.getAgentId();
        if (agentId == null) {
            System.out.println("Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
            return error.concat("AgentId=null");
        }
        String hostAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getHost();
        int portAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getPort();
        try {
            AgentLibrary agentLibrary = null;
            ScopeProvider.instance.set("/gcube/devsec");
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
            String status = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getStatus();
            System.out.println("Stateful Service(cancelScheduledTransfer) - status before Calling the cancelTransfer in Agent!! = " + status);
            if (status == "COMPLETED" || status == "FAILED") {
                if (typeOfSchedule.getPeriodicallyScheduledId() == null) return error.concat("Transfer already done");
                try {
                    this.dbManager.updateTransferStatus(transferId, "CANCELED");
                    return "DONE";
                }
                catch (Exception e) {
                    System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                    error = error.concat(e.getMessage());
                    e.printStackTrace();
                    return error;
                }
            }
            if (status == "CANCELED") {
                return "DONE";
            }
            if (status == "STANDBY") {
                try {
                    this.dbManager.updateTransferStatus(transferId, "CANCELED");
                    return "DONE";
                }
                catch (Exception e) {
                    System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
                    error = error.concat(e.getMessage());
                    e.printStackTrace();
                    return error;
                }
            }
            String transferIdOfAgent = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getTransferIdOfAgent();
            if (transferIdOfAgent == null) {
                System.out.println("Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
                return error.concat("TransferIdOfAgent=null");
            }
            agentLibrary.cancelTransfer(transferIdOfAgent, isForceCancel.booleanValue());
        }
        catch (Exception e) {
            error = error.concat(e.getMessage());
            System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in calling the cancelTransfer\n");
            e.printStackTrace();
            return error;
        }
        try {
            this.dbManager.updateTransferStatus(transferId, "CANCELED");
        }
        catch (Exception e) {
            System.out.println("\nStateful Service(cancelScheduledTransfer) - Exception in updating the status to Canceled\n");
            error = error.concat(e.getMessage());
            e.printStackTrace();
            return error;
        }
        System.out.println("\nStateful Service(cancelScheduledTransfer) - status=" + ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getStatus());
        return "DONE";
    }

    public String monitorScheduledTransfer(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManager = new ISManager(this.dbManager);
        String transferId = msg;
        String status = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getStatus();
        return status;
    }

    public String getScheduledTransferOutcomes(String msg) throws GCUBEFault {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.isManager = new ISManager(this.dbManager);
        String error = new String("Error:");
        StringBuilder outcomesResult = new StringBuilder();
        String transferId = msg;
        String transferIdOfAgent = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getTransferIdOfAgent();
        if (transferIdOfAgent == null) {
            return "The Transfer has not started yet or It is a sync op.";
        }
        String agentId = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId)).getAgentId();
        if (agentId == null) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Error - agentId=null");
            error = error.concat("Stateful Service(monitorScheduledTransfer) - agentId=null");
            return error;
        }
        String hostAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getHost();
        int portAgent = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)agentId)).getPort();
        AgentLibrary agentLibrary = null;
        try {
            ScopeProvider.instance.set("/gcube/devsec");
            agentLibrary = (AgentLibrary)Proxies.transferAgent().at(hostAgent, portAgent).build();
        }
        catch (Exception e) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when building agentLibrary");
            error = error.concat(e.getMessage());
            e.printStackTrace();
            return error;
        }
        try {
            ArrayList outcomes = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);
            int numOfObj = 0;
            for (FileTransferOutcome outcome : outcomes) {
                outcomesResult.append("Outcome-" + numOfObj + "\n");
                outcomesResult.append("Exception: " + outcome.getException() + "\n");
                outcomesResult.append("FileName: " + outcome.getFilename() + "\n");
                outcomesResult.append("Success?: " + outcome.isSuccess() + "\n");
                outcomesResult.append("Failure?: " + outcome.isFailure() + "\n");
                ++numOfObj;
            }
        }
        catch (Exception e) {
            System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when calling the getTransferOutcomes and read the outcomes");
            error = error.concat(e.getMessage());
            e.printStackTrace();
            return error;
        }
        return outcomesResult.toString();
    }

    private Resource getResource() throws ResourceException {
        return (Resource)StatefulContext.getContext().getWSHome().find();
    }
}

