/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.impl.porttype.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.porttype.StatelessContext;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SampleFault;

public class Stateless
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(Stateless.class);

    public String about(String name) throws GCUBEFault, SampleFault {
        GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)"/gcube/devsec/"));
        StringBuilder output = new StringBuilder();
        GHNContext nctx = GHNContext.getContext();
        ServiceContext sctx = ServiceContext.getContext();
        StatelessContext pctx = StatelessContext.getContext();
        try {
            output.append("Hello " + name).append(", you have invoked porttype ").append(String.valueOf(pctx.getName()) + " of service " + sctx.getName()).append(", which you found ").append(" on the GHN " + nctx.getGHNID()).append(" at " + pctx.getEPR() + " in the gCube infrastructure " + nctx.getGHN().getInfrastructure());
        }
        catch (GCUBEException e) {
            logger.error((Object)"Problem in about():", (Throwable)e);
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
        return output.toString();
    }

    public String getAddr(String tmp) throws GCUBEFault, SampleFault {
        GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)"/gcube/devsec/"));
        ServiceContext sctx = ServiceContext.getContext();
        StatelessContext pctx = StatelessContext.getContext();
        try {
            return pctx.getEPR().toString().replaceFirst("Address: ", "").replaceAll("\n", "");
        }
        catch (Exception e) {
            logger.error((Object)"Problem in about()", (Throwable)e);
            throw sctx.getDefaultException("Problem in about()", e).toFault(new String[0]);
        }
    }

    public GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

