/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.context;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerRIResourceConsumer;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private DataTransferDBManager dbManager = null;
    private String dbConfigurationFileName = null;
    private ISManager<Agent> isManagerForAgents = null;
    private ISManager<DataSource> isManagerForSources = null;
    private ISManager<DataStorage> isManagerForStorages = null;

    protected void onInitialisation() throws Exception {
        this.dbConfigurationFileName = (String)this.getProperty("dbConfigurationFile", new boolean[]{true});
        this.dbManager = new DataTransferDBManager(this.dbConfigurationFileName, ServiceContext.getContext().getPersistenceRoot().getAbsolutePath(), (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{true}));
        this.getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new SchedulerRIResourceConsumer(), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE});
    }

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/datatransfer/scheduler/";
    }

    public DataTransferDBManager getDbManager() {
        return this.dbManager;
    }

    public void setDbManager(DataTransferDBManager dbManager) {
        this.dbManager = dbManager;
    }

    public ISManager<Agent> getIsManagerForAgents() {
        return this.isManagerForAgents;
    }

    public void setIsManagerForAgents(ISManager<Agent> isManagerForAgents) {
        this.isManagerForAgents = isManagerForAgents;
    }

    public ISManager<DataSource> getIsManagerForSources() {
        return this.isManagerForSources;
    }

    public void setIsManagerForSources(ISManager<DataSource> isManagerForSources) {
        this.isManagerForSources = isManagerForSources;
    }

    public ISManager<DataStorage> getIsManagerForStorages() {
        return this.isManagerForStorages;
    }

    public void setIsManagerForStorages(ISManager<DataStorage> isManagerForStorages) {
        this.isManagerForStorages = isManagerForStorages;
    }

    public String getDbConfigurationFileName() {
        return this.dbConfigurationFileName;
    }

    public void setDbConfigurationFileName(String dbConfigurationFileName) {
        this.dbConfigurationFileName = dbConfigurationFileName;
    }
}

