package org.gcube.datatransfer.scheduler.impl.check;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.jdo.Query;

import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;

public class CheckDBForTransfersThread extends Thread {

	public DataTransferDBManager dbManager=null;
	public SchedulerResource resource=null;
	public long checkForTransfersIntervalMS;
	public boolean immediateCheck;
	GCUBELog logger = new GCUBELog(CheckDBForTransfersThread.class);
	
	public CheckDBForTransfersThread(GCUBEWSResource ws) {
		this.dbManager=ServiceContext.getContext().getDbManager();	
		this.resource=(SchedulerResource) ws;
		this.checkForTransfersIntervalMS=1000 * Integer.valueOf((String) ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", true));
		this.immediateCheck=true; //the first time needs to check db
	}

	public void run() {		
		int runs=0;
		long initialInterval=0;
		long tempInterval=0;
		logger.debug("\nCheckDBForTransfersThread - "+this.resource.getName()+" -- Thread has started");

		do {
			runs++;
			if(runs==1){
				this.sleepFiveSec();
			}
			
			// sleeping for checkForTransfersIntervalMS
			initialInterval=this.checkForTransfersIntervalMS;
			tempInterval=this.checkForTransfersIntervalMS;
			do {				
				this.sleepFiveSec();
				tempInterval=tempInterval-5000;
			}while(tempInterval>0 && initialInterval==this.checkForTransfersIntervalMS && this.immediateCheck==false);

			
			if(this.immediateCheck==true){
				this.sleepFiveSec();
				logger.debug("\nCheckDBForTransfersThread -- immediate check");
				this.immediateCheck=false;
			}
			else if (initialInterval!=this.checkForTransfersIntervalMS){
				logger.debug("\nCheckDBForTransfersThread -- interval has been changed from "+initialInterval+" MS to "+this.checkForTransfersIntervalMS+" MS");
			}
			
			//*** check for transfers ***
			//Retrieve all the activated transfers by query			
			Query query=null;
			List<Transfer> list=null;
			query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
			try{
				query.setFilter("status == \"STANDBY\" && submitter == \""+this.resource.getName()+"\"");
			}catch(Exception e){
				logger.error("\nCheckDBForTransfersThread -- Exception in retrieving all the activated transfers by query");
				e.printStackTrace();
			}			
			list = (List<Transfer>) query.execute();
					
			CheckDBForTransfers checkDBForTransfers = new CheckDBForTransfers(this.resource,list);
			checkDBForTransfers.check();
			
		} while (! Thread.interrupted());
	}

	public void sleepFiveSec(){
		try {
			Thread.sleep(5000);
		} catch (InterruptedException e) {
			logger.error("\nCheckDBForTransfersThread (sleepFiveSec)-- InterruptedException-Unable to sleep");
			e.printStackTrace();
		}
	}
	
	public long getCheckForTransfersIntervalMS() {
		return checkForTransfersIntervalMS;
	}
	public void setCheckForTransfersIntervalMS(long checkForTransfersIntervalMS) {
		this.checkForTransfersIntervalMS = checkForTransfersIntervalMS;
	}
	public boolean isImmediateCheck() {
		return immediateCheck;
	}
	public void setImmediateCheck(boolean immediateCheck) {
		this.immediateCheck = immediateCheck;
	}
	
	public void resetCheckForTransfersInterval(){
		this.checkForTransfersIntervalMS=1000 * Integer.valueOf((String) ServiceContext.getContext().getProperty("checkForTransfersIntervalInSeconds", true));
	}
	
}