package org.gcube.datatransfer.scheduler.impl.state;

import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEResource.ResourceConsumer;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.impl.check.CheckIS;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.is.ISManager;


public class SchedulerRIResourceConsumer extends ResourceConsumer{

	GCUBELog logger = new GCUBELog(this);

	/**
	 * {@inheritDoc}
	 */
	protected void onAddScope(GCUBEResource.AddScopeEvent event) {

		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		for (GCUBEScope scope: event.getPayload())
		{
			//creating the ISManagerForAgents and setting it in the ServiceContext
			ISManager isManagerForAgents = new ISManager("Agent",ServiceContext.getContext().getDbManager(), scope.toString());
			ServiceContext.getContext().setIsManagerForAgents(isManagerForAgents);
			//creating the ISManagerForSources and setting it in the ServiceContext
			ISManager isManagerForSources = new ISManager("DataSource",ServiceContext.getContext().getDbManager(), scope.toString());
			ServiceContext.getContext().setIsManagerForSources(isManagerForSources);
			//creating the ISManagerForStorages and setting it in the ServiceContext
			ISManager isManagerForStorages = new ISManager("DataStorage",ServiceContext.getContext().getDbManager(), scope.toString());
			ServiceContext.getContext().setIsManagerForStorages(isManagerForStorages);

			logger.debug("RIResourceConsumer - onAddScope.. just created a CheckISThread and three ISManagers(for Agents-Sources-Storages) in scope="+scope.toString());

			// **** CheckIS Thread ****
			CheckIS checkIS = new CheckIS();
			checkIS.start();
		}
	}
}