/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.Query;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TransferOutcome;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;

public class TransferHandler
extends Thread {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    Transfer transfer;
    String submitter;
    String transferId;
    DataTransferDBManager dbManager;
    SchedulerResource resource;
    String transferType;
    long checkForMonitorResultIntervalMS;
    long maxTimeForMonitoringWithQueuedResultMS;
    AgentLibrary agentLibrary = null;
    List<String> objectTrasferredIDs = new ArrayList<String>();
    List<String> objectFailedIDs = new ArrayList<String>();
    boolean failed = false;
    List<String> errorsInTransfer = new ArrayList<String>();
    Agent agent;
    String hostAgent;
    int portAgent;
    GCUBELog logger = new GCUBELog(TransferHandler.class);

    public TransferHandler(String transferId, GCUBEWSResource ws, boolean isPeriodically) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.transferId = transferId;
        this.resource = (SchedulerResource)ws;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        this.agent = null;
        this.submitter = this.transfer.getSubmitter();
        this.transferType = this.transfer.getTransferType();
        this.checkForMonitorResultIntervalMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("checkForMonitorResultIntervalInSeconds", new boolean[]{true}));
        this.maxTimeForMonitoringWithQueuedResultMS = 1000 * Integer.valueOf((String)ServiceContext.getContext().getProperty("maxTimeForMonitoringWithQueuedResultInSeconds", new boolean[]{true}));
    }

    @Override
    public void run() {
        this.logger.debug((Object)("\nTransferHandler - " + this.resource.getName() + " -- Thread has started"));
        String agentId = this.transfer.getAgentId();
        if (agentId == null) {
            this.logger.error((Object)"TransferHandler - Error - agentId=null");
            this.errorsInTransfer.add("TransferHandler - Error - agentId=null");
            this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
            return;
        }
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            Agent obj = (Agent)iter.next();
            if (obj.getAgentId().compareTo(agentId) != 0) continue;
            this.agent = obj;
            this.hostAgent = obj.getHost();
            this.portAgent = obj.getPort();
            flagExists = true;
            break;
        }
        if (!flagExists) {
            this.logger.error((Object)("TransferHandler - Error - agent with id=" + agentId + " does not exist in DB anymore"));
            this.errorsInTransfer.add("TransferHandler - Error - agent with id=" + agentId + " does not exist in DB anymore");
            this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
            return;
        }
        if (this.hostAgent == null) {
            this.logger.error((Object)"TransferHandler - Error - hostAgent=null");
            this.errorsInTransfer.add("TransferHandler - Error - hostAgent=null");
            this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
            return;
        }
        this.updateAgentStatistics("ONGOING");
        this.addActiveTransferResource();
        if (this.transferType.compareTo("LocalFileBasedTransfer") == 0) {
            this.logger.error((Object)"TransferHandler - Error - LocalFileBasedTransfer is not used anymore");
            this.errorsInTransfer.add("TransferHandler - LocalFileBasedTransfer is not used anymore");
            this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
            return;
        }
        if (this.transferType.compareTo("FileBasedTransfer") == 0) {
            this.fileBasedProcess();
        } else if (this.transferType.compareTo("TreeBasedTransfer") == 0) {
            this.treeBasedProcess();
        }
        this.refreshPeriodicallyScheduledTransfer();
    }

    public void refreshPeriodicallyScheduledTransfer() {
        String idTypeOfSchedule = this.transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
        String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
        String retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
        if (periodicallyScheduledId != null && retrivedStatus != "CANCELED") {
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = periodicallyScheduled.getStartInstance();
            try {
                this.dbManager.updateTransferStartInstance(this.transferId, Calendar.getInstance());
            }
            catch (Exception e) {
                this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer startInstance (1)- " + this.submitter + " - id=" + this.transferId));
                e.printStackTrace();
            }
            try {
                Utils.FrequencyType frequencyType = periodicallyScheduled.getFrequency();
                if (frequencyType == Utils.FrequencyType.perYear) {
                    startInstance.add(1, 1);
                } else if (frequencyType == Utils.FrequencyType.perMonth) {
                    startInstance.add(2, 1);
                } else if (frequencyType == Utils.FrequencyType.perWeek) {
                    startInstance.add(5, 7);
                } else if (frequencyType == Utils.FrequencyType.perDay) {
                    startInstance.add(5, 1);
                } else if (frequencyType == Utils.FrequencyType.perHour) {
                    startInstance.add(11, 1);
                } else if (frequencyType == Utils.FrequencyType.perMinute) {
                    startInstance.add(12, 1);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("\nTransferHandler -- Exception in forward the startInstance - " + this.submitter + " - id=" + this.transferId));
                e.printStackTrace();
            }
            try {
                Calendar tmpCalendar = (Calendar)startInstance.clone();
                tmpCalendar.set(1, startInstance.get(1));
                tmpCalendar.set(2, startInstance.get(2));
                tmpCalendar.set(5, startInstance.get(5));
                tmpCalendar.set(11, startInstance.get(11));
                tmpCalendar.set(12, startInstance.get(12));
                this.dbManager.updateTransferStartInstance(this.transferId, tmpCalendar);
            }
            catch (Exception e) {
                this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer startInstance (2)- " + this.submitter + " - id=" + this.transferId));
                e.printStackTrace();
            }
            this.updateStatusAndErrors(this.transferId, "STANDBY", null);
        }
    }

    public void addActiveTransferResource() {
        String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
        String[] newActiveTransferIDS = new String[alreadyActiveTransferIDs.length + 1];
        int i = 0;
        String[] arr$ = alreadyActiveTransferIDs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String temp;
            newActiveTransferIDS[i] = temp = arr$[i$];
            ++i;
        }
        newActiveTransferIDS[i] = this.transferId;
        try {
            this.resource.setActiveTransfers(newActiveTransferIDS);
            this.resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler (addResourceOfActiveTransfer)-- Exception in Storing the Resource Property 'ActiveTransfers'");
            e.printStackTrace();
        }
        try {
            int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
            String newNumberOfActive = alreadyNumberOfActive + 1 + "";
            this.resource.setNumOfActiveTransfers(newNumberOfActive);
            this.resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler (addResourceOfActiveTransfer) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'");
            e.printStackTrace();
        }
    }

    public void removeActiveTransferResource() {
        String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
        String[] newActiveTransferIDS = new String[alreadyActiveTransferIDs.length - 1];
        int i = 0;
        for (String temp : alreadyActiveTransferIDs) {
            if (this.transferId.compareTo(temp) == 0) continue;
            newActiveTransferIDS[i] = temp;
            ++i;
        }
        try {
            this.resource.setActiveTransfers(newActiveTransferIDS);
            this.resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler (removeActiveTransferResource)-- Exception in Storing the Resource Property 'ActiveTransfers'");
            e.printStackTrace();
        }
        try {
            int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
            String newNumberOfActive = alreadyNumberOfActive - 1 + "";
            this.resource.setNumOfActiveTransfers(newNumberOfActive);
            this.resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler (removeActiveTransferResource) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'");
            e.printStackTrace();
        }
    }

    public void sleepSixSec() {
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nTransferHandler (sleepFiveSec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }

    public void updateStatusAndErrors(String transferId, String status, List<String> errorsInTransfer) {
        try {
            ServiceContext.getContext().getDbManager().updateTransferStatus(this.transferId, status);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception in changing the transfer status\n");
            e.printStackTrace();
        }
        if (errorsInTransfer != null) {
            try {
                this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception in updating the transfer errors\n");
                e.printStackTrace();
            }
        }
        if (status.compareTo("STANDBY") != 0 && status.compareTo("QUEUED") != 0) {
            this.removeActiveTransferResource();
            this.updateAgentStatistics(status);
        }
    }

    public void updateAgentStatistics(String status) {
        if (this.agent == null) {
            return;
        }
        String agentIdOfIS = this.agent.getAgentIdOfIS();
        AgentStatistics stats = null;
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(AgentStatistics.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            AgentStatistics obj = (AgentStatistics)iter.next();
            if (obj.getAgentIdOfIS().compareTo(agentIdOfIS) != 0) continue;
            stats = obj;
            flagExists = true;
            break;
        }
        if (!flagExists) {
            return;
        }
        String id = stats.getAgentStatisticsId();
        int ongoing = stats.getOngoingTransfers();
        int failed = stats.getFailedTransfers();
        int succeeded = stats.getSucceededTransfers();
        int canceled = stats.getCanceledTransfers();
        int total = stats.getTotalFinishedTransfers();
        if (status.compareTo("COMPLETED") == 0) {
            --ongoing;
            ++succeeded;
            ++total;
        } else if (status.compareTo("COMPLETED_WITH_ERRORS") == 0) {
            --ongoing;
            ++succeeded;
            ++total;
        } else if (status.compareTo("FAILED") == 0) {
            --ongoing;
            ++failed;
            ++total;
        } else if (status.compareTo("CANCELED") == 0) {
            --ongoing;
            ++canceled;
            ++total;
        } else if (status.compareTo("ONGOING") == 0) {
            ++ongoing;
        }
        try {
            this.dbManager.updateAgentStatistics(id, ongoing, failed, succeeded, canceled, total);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception in updating the agent Statistics\n");
            e.printStackTrace();
        }
    }

    public void fileBasedProcess() {
        String scope;
        TransferOptions transferOptions;
        String transferIdOfAgent = null;
        ArrayList<TransferObject> objectsToBeTransferred = new ArrayList<TransferObject>();
        Query query = null;
        List list = null;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        boolean flagReadyObjs = this.transfer.isReadyObjects();
        int numSleeps = 0;
        while (!flagReadyObjs) {
            this.logger.debug((Object)("TransferHandler -- DB has not finished storing the objs.. sec=" + numSleeps * 6));
            this.sleepSixSec();
            this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
            flagReadyObjs = this.transfer.isReadyObjects();
            if (++numSleeps <= 20) continue;
            this.logger.debug((Object)"TransferHandler -- DB did not store the objs in 120s .. transfer aborted-failed..");
            this.updateStatusAndErrors(this.transferId, "FAILED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
        list = (List)query.execute();
        this.logger.debug((Object)("TransferHandler -- listOfObjects=" + list.size() + " -- transferId=" + this.transferId));
        for (TransferObject obj : list) {
            String transferIdOfSpecific = obj.getTransferid();
            if (transferIdOfSpecific.compareTo(this.transferId) != 0) continue;
            objectsToBeTransferred.add(obj);
        }
        this.logger.debug((Object)("TransferHandler -- listOfObjectsToBeTransferrwes=" + objectsToBeTransferred.size()));
        ArrayList<URI> inputUris = new ArrayList<URI>();
        for (TransferObject obj : objectsToBeTransferred) {
            inputUris.add(obj.getSrcURI());
        }
        Types.storageType typeOfStorage = null;
        Types.StorageManagerDetails storageManagerDetails = new Types.StorageManagerDetails();
        if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.LocalGHN.name()) == 0) {
            typeOfStorage = Types.storageType.LocalGHN;
            this.logger.debug((Object)"TransferHandler -- storageType=LocalGHN");
            String destinationFolder = this.transfer.getDestinationFolder();
            transferOptions = new TransferOptions();
            transferOptions.setType(typeOfStorage);
            transferOptions.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions.setStorageManagerDetails(storageManagerDetails);
            scope = this.transfer.getScope();
            this.logger.debug((Object)("TransferHandler -- scooooooooope=" + scope));
            try {
                ScopeProvider.instance.set(scope);
                this.agentLibrary = (AgentLibrary)Proxies.transferAgent().at(this.hostAgent, this.portAgent).build();
                this.logger.debug((Object)"TransferHandler - print inputUris before call:");
                for (URI tmp : inputUris) {
                    this.logger.debug((Object)tmp);
                }
                transferIdOfAgent = this.agentLibrary.startTransfer(inputUris, destinationFolder, transferOptions);
                this.logger.debug((Object)"TransferHandler - After the agentLibrary.startTransfer(...)");
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
                this.errorsInTransfer.add(e.getMessage());
                this.failed = true;
                e.printStackTrace();
            }
        } else if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.StorageManager.name()) == 0) {
            DataStorage storage = null;
            String storageId = this.transfer.getStorageId();
            Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
            Iterator iter = resultExtent.iterator();
            boolean flagExists = false;
            while (iter.hasNext()) {
                DataStorage obj = (DataStorage)iter.next();
                if (obj.getDataStorageId().compareTo(storageId) != 0) continue;
                storage = obj;
                flagExists = true;
                break;
            }
            if (!flagExists) {
                this.logger.error((Object)("TransferHandler - Error - datastorage with id=" + storageId + " does not exist in DB anymore"));
                this.errorsInTransfer.add("TransferHandler - Error - datastorage with id=" + storageId + " does not exist in DB anymore");
                this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
                return;
            }
            typeOfStorage = Types.storageType.StorageManager;
            this.logger.debug((Object)"TransferHandler -- storageType=StorageManager");
            storageManagerDetails.setOwner(storage.getOwner());
            storageManagerDetails.setServiceName(storage.getServiceName());
            storageManagerDetails.setServiceClass(storage.getServiceClass());
            storageManagerDetails.setAccessType(Types.storageAccessType.valueOf((String)storage.getAccessType()));
            String destinationFolder = this.transfer.getDestinationFolder();
            TransferOptions transferOptions2 = new TransferOptions();
            transferOptions2.setType(typeOfStorage);
            transferOptions2.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions2.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions2.setStorageManagerDetails(storageManagerDetails);
            String scope2 = this.transfer.getScope();
            this.logger.debug((Object)("TransferHandler -- scooooooooope=" + scope2));
            try {
                ScopeProvider.instance.set(scope2);
                this.agentLibrary = (AgentLibrary)Proxies.transferAgent().at(this.hostAgent, this.portAgent).build();
                this.logger.debug((Object)"TransferHandler - print inputUris before call:");
                for (URI tmp : inputUris) {
                    this.logger.debug((Object)tmp);
                }
                transferIdOfAgent = this.agentLibrary.startTransfer(inputUris, destinationFolder, transferOptions2);
                this.logger.debug((Object)"TransferHandler - After the agentLibrary.startTransfer(...)");
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
                this.errorsInTransfer.add(e.getMessage());
                this.failed = true;
                e.printStackTrace();
            }
        } else if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.DataStorage.name()) == 0) {
            typeOfStorage = Types.storageType.DataStorage;
            this.logger.debug((Object)"TransferHandler -- storageType=DataStorage");
            ArrayList<URI> outputURIs = new ArrayList<URI>();
            for (TransferObject obj : objectsToBeTransferred) {
                try {
                    outputURIs.add(new URI(obj.getDestUri()));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            transferOptions = new TransferOptions();
            transferOptions.setType(typeOfStorage);
            transferOptions.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions.setStorageManagerDetails(storageManagerDetails);
            scope = this.transfer.getScope();
            this.logger.debug((Object)("TransferHandler -- scooooooooope=" + scope));
            try {
                ScopeProvider.instance.set(scope);
                this.agentLibrary = (AgentLibrary)Proxies.transferAgent().at(this.hostAgent, this.portAgent).build();
                this.logger.debug((Object)"TransferHandler - print inputUris before call:");
                for (URI tmp : inputUris) {
                    this.logger.debug((Object)tmp);
                }
                transferIdOfAgent = this.agentLibrary.startTransfer(inputUris, outputURIs, transferOptions);
                this.logger.debug((Object)"TransferHandler - After the agentLibrary.startTransfer(...)");
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception when call agentLibrary.startTransfer(inputUris, outputURIs, transferOptions)");
                this.errorsInTransfer.add(e.getMessage());
                this.failed = true;
                e.printStackTrace();
            }
        }
        if (transferIdOfAgent == null) {
            this.logger.debug((Object)"TransferHandler - transferIdOfAgent==null - transfer becomes FAILED");
            this.updateStatusAndErrors(this.transferId, "FAILED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        try {
            ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId, transferIdOfAgent);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
            e.printStackTrace();
        }
        String resultOfMonitoring = "";
        boolean flagCont = true;
        int limit = 10;
        int num = 0;
        long time = 0L;
        do {
            try {
                resultOfMonitoring = this.agentLibrary.monitorTransfer(transferIdOfAgent);
                this.logger.debug((Object)("TransferHandler - After the agentLibrary.monitorTransfer(...) - result=" + resultOfMonitoring + ", ********************"));
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception when call agentLibrary.monitorTransfer(.....)");
                this.errorsInTransfer.add(e.getMessage());
                e.printStackTrace();
            }
            try {
                Thread.sleep(this.checkForMonitorResultIntervalMS);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"TransferHandler -- InterruptedException-Unable to sleep");
                e.printStackTrace();
            }
            if (resultOfMonitoring == null) {
                flagCont = true;
                ++num;
                continue;
            }
            if (resultOfMonitoring.compareTo("QUEUED") == 0) {
                this.logger.debug((Object)("TransferHandler - QUEUED result: time=" + (time += this.checkForMonitorResultIntervalMS) + "MS, maxTime=" + this.maxTimeForMonitoringWithQueuedResultMS + "MS"));
                flagCont = true;
                continue;
            }
            flagCont = resultOfMonitoring.compareTo("STARTED") == 0;
        } while (flagCont && num <= limit && time <= this.maxTimeForMonitoringWithQueuedResultMS);
        if (resultOfMonitoring == null) {
            this.logger.debug((Object)("TransferHandler -- monitorTransfer result was still null after " + limit + " calls, the transfer becomes FAILED"));
            this.updateStatusAndErrors(this.transferId, "FAILED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        if (resultOfMonitoring.compareTo("QUEUED") == 0) {
            this.logger.debug((Object)("TransferHandler -- monitorTransfer result was still QUEUED after " + this.maxTimeForMonitoringWithQueuedResultMS + " MS, the transfer becomes FAILED"));
            this.updateStatusAndErrors(this.transferId, "FAILED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        this.logger.debug((Object)("TransferHandler -- monitorTransfer result=" + resultOfMonitoring));
        String retrivedStatus = ((Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId)).getStatus();
        if (retrivedStatus.compareTo("CANCELED") == 0) {
            this.logger.debug((Object)"TransferHandler -- Canceled");
            this.updateStatusAndErrors(this.transferId, "CANCELED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        if (resultOfMonitoring.compareTo("CANCEL") == 0) {
            this.logger.debug((Object)("TransferHandler -- Canceled - " + this.submitter + " - id=" + this.transferId));
            this.updateStatusAndErrors(this.transferId, "CANCELED", null);
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
        ArrayList outcomes = null;
        try {
            outcomes = this.agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception when call agentLibrary.getTransferOutcomes(..) ");
            this.errorsInTransfer.add(e.getMessage());
            e.printStackTrace();
        }
        ArrayList listOfOutcomesToBeStored = null;
        if (outcomes != null) {
            try {
                int numOfObj = 0;
                ArrayList<String> tmpOutcomes = new ArrayList<String>();
                for (FileTransferOutcome outcome : outcomes) {
                    TransferOutcome transferOutcome = new TransferOutcome();
                    String outcomeId = uuidgen.nextUUID();
                    transferOutcome.setTransferOutcomesId(outcomeId);
                    transferOutcome.setTransferId(this.transferId);
                    transferOutcome.setSubmittedDateOfTransfer(this.transfer.getSubmittedDate());
                    transferOutcome.setFileName(outcome.getFilename());
                    transferOutcome.setException(outcome.getException());
                    transferOutcome.setFailure(outcome.isFailure());
                    transferOutcome.setSuccess(outcome.isSuccess());
                    transferOutcome.setDest(outcome.getDest());
                    transferOutcome.setTransferTime(outcome.getTransferTime() + "");
                    transferOutcome.setNumberOfOutcomeInThisTransfer(numOfObj);
                    this.dbManager.storeTransferOutcomes(transferOutcome);
                    if (numOfObj == 0) {
                        this.logger.debug((Object)"TransferHandler -- getTransferOutcomes:");
                    }
                    this.logger.debug((Object)("Exception: " + outcome.getException()));
                    this.logger.debug((Object)("FileName: " + outcome.getFilename()));
                    this.logger.debug((Object)("Success?: " + outcome.isSuccess()));
                    this.logger.debug((Object)("Failure?: " + outcome.isFailure()));
                    if (this.transfer.getSourceId() == null) {
                        if (outcome.isFailure()) {
                            this.objectFailedIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                        } else if (outcome.isSuccess()) {
                            this.objectTrasferredIDs.add(((TransferObject)objectsToBeTransferred.get(numOfObj)).getObjectId());
                        }
                    }
                    tmpOutcomes.add(outcomeId);
                    ++numOfObj;
                }
                listOfOutcomesToBeStored = this.transfer.getOutcomes();
                if (listOfOutcomesToBeStored == null) {
                    listOfOutcomesToBeStored = new ArrayList();
                }
                listOfOutcomesToBeStored.addAll(tmpOutcomes);
            }
            catch (Exception e) {
                this.logger.error((Object)"TransferHandler - Exception when call dbManager.storeTransferOutcomes");
                this.errorsInTransfer.add(e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            if (listOfOutcomesToBeStored != null) {
                this.dbManager.updateOutcomesInTransfer(this.transferId, listOfOutcomesToBeStored);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"TransferHandler - Exception when call dbManager.updateOutcomesInTransfer ");
            this.errorsInTransfer.add(e.getMessage());
            e.printStackTrace();
        }
        if (resultOfMonitoring.compareTo("DONE") == 0 || resultOfMonitoring.compareTo("DONE_WITH_ERRORS") == 0) {
            String status = null;
            try {
                status = resultOfMonitoring.compareTo("DONE") == 0 ? "COMPLETED" : "COMPLETED_WITH_ERRORS";
                this.updateStatusAndErrors(this.transferId, status, null);
                this.logger.debug((Object)("TransferHandler -- " + status + " - " + this.submitter + " - id=" + this.transferId));
                if (this.transfer.getSourceId() == null) {
                    String[] objectFailedIDsarray = this.objectFailedIDs.toArray(new String[this.objectFailedIDs.size()]);
                    String[] objectTrasferredIDsarray = this.objectTrasferredIDs.toArray(new String[this.objectTrasferredIDs.size()]);
                    this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
                    this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("TransferHandler -- If " + status + " - Exception"));
                e.printStackTrace();
            }
            if (this.transfer.getSourceId() == null) {
                for (String objId : this.transfer.getObjectTrasferredIDs()) {
                    this.logger.debug((Object)("TransferHandler -- Completed - TransferredObjectID:" + objId));
                }
                for (String objId : this.transfer.getObjectFailedIDs()) {
                    this.logger.debug((Object)("TransferHandler -- Completed - FailedObjectID:" + objId));
                }
            }
        } else if (resultOfMonitoring.compareTo("FAILED") == 0) {
            this.updateStatusAndErrors(this.transferId, "FAILED", this.errorsInTransfer);
            this.logger.debug((Object)("TransferHandler -- Failed - " + this.submitter + " - id=" + this.transferId));
            this.refreshPeriodicallyScheduledTransfer();
            return;
        }
    }

    public void treeBasedProcess() {
        String scope = this.transfer.getScope();
        ScopeProvider.instance.set(scope);
    }
}

