/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.newhandler;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.db.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.utils.Utils;

public class SchedulerUtils {
    private static DataTransferDBManager dbManager = ServiceContext.getContext().getDbManager();
    private static GCUBELog logger = new GCUBELog(SchedulerUtils.class);

    public static void updateStatusAndErrors(String transferId, Agent agent, String status, List<String> errorsInTransfer) {
        try {
            ServiceContext.getContext().getDbManager().updateTransferStatus(transferId, status);
        }
        catch (Exception e) {
            logger.error((Object)"TransferHandler - Exception in changing the transfer status\n");
            e.printStackTrace();
        }
        if (errorsInTransfer != null) {
            try {
                dbManager.updateTransferError(transferId, errorsInTransfer);
            }
            catch (Exception e) {
                logger.error((Object)"TransferHandler - Exception in updating the transfer errors\n");
                e.printStackTrace();
            }
        }
        if (status.compareTo("STANDBY") != 0 && status.compareTo("QUEUED") != 0) {
            SchedulerUtils.updateAgentStatistics(status, agent);
        }
    }

    public static void updateAgentStatistics(String status, Agent agent) {
        if (agent == null) {
            return;
        }
        String agentIdOfIS = agent.getAgentIdOfIS();
        AgentStatistics stats = null;
        Extent resultExtent = dbManager.getPersistenceManager().getExtent(AgentStatistics.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            AgentStatistics obj = (AgentStatistics)iter.next();
            if (obj.getAgentIdOfIS().compareTo(agentIdOfIS) != 0) continue;
            stats = obj;
            flagExists = true;
            break;
        }
        if (!flagExists) {
            return;
        }
        String id = stats.getAgentStatisticsId();
        int ongoing = stats.getOngoingTransfers();
        int failed = stats.getFailedTransfers();
        int succeeded = stats.getSucceededTransfers();
        int canceled = stats.getCanceledTransfers();
        int total = stats.getTotalFinishedTransfers();
        if (status.compareTo("COMPLETED") == 0) {
            --ongoing;
            ++succeeded;
            ++total;
        } else if (status.compareTo("COMPLETED_WITH_ERRORS") == 0) {
            --ongoing;
            ++succeeded;
            ++total;
        } else if (status.compareTo("FAILED") == 0) {
            --ongoing;
            ++failed;
            ++total;
        } else if (status.compareTo("CANCELED") == 0) {
            --ongoing;
            ++canceled;
            ++total;
        } else if (status.compareTo("ONGOING") == 0) {
            ++ongoing;
        }
        try {
            dbManager.updateAgentStatistics(id, ongoing, failed, succeeded, canceled, total);
        }
        catch (Exception e) {
            logger.error((Object)"TransferHandler - Exception in updating the agent Statistics\n");
            e.printStackTrace();
        }
    }

    public static void refreshPeriodicallyScheduledTransfer(String transferId, String submitter, Agent agent) {
        Transfer transfer = (Transfer)dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)transferId);
        String idTypeOfSchedule = transfer.getTypeOfScheduleId();
        TypeOfSchedule typeOfSchedule = (TypeOfSchedule)dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
        String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
        String retrivedStatus = transfer.getStatus();
        if (periodicallyScheduledId != null && retrivedStatus != "CANCELED") {
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = null;
            startInstance = Utils.getCalendarBasedOnStringDate(periodicallyScheduled.getStartInstanceString());
            try {
                Utils.FrequencyType frequencyType = periodicallyScheduled.getFrequency();
                if (frequencyType == Utils.FrequencyType.perYear) {
                    startInstance.add(1, 1);
                } else if (frequencyType == Utils.FrequencyType.perMonth) {
                    startInstance.add(2, 1);
                } else if (frequencyType == Utils.FrequencyType.perWeek) {
                    startInstance.add(5, 7);
                } else if (frequencyType == Utils.FrequencyType.perDay) {
                    startInstance.add(5, 1);
                } else if (frequencyType == Utils.FrequencyType.perHour) {
                    startInstance.add(11, 1);
                } else if (frequencyType == Utils.FrequencyType.perMinute) {
                    startInstance.add(12, 1);
                }
            }
            catch (Exception e) {
                logger.error((Object)("\nTransferHandler -- Exception in forward the startInstance - " + submitter + " - id=" + transferId));
                e.printStackTrace();
            }
            try {
                Calendar tmpCalendar = (Calendar)startInstance.clone();
                tmpCalendar.set(1, startInstance.get(1));
                tmpCalendar.set(2, startInstance.get(2));
                tmpCalendar.set(5, startInstance.get(5));
                tmpCalendar.set(11, startInstance.get(11));
                tmpCalendar.set(12, startInstance.get(12));
                dbManager.updateTransferStartInstanceString(transferId, Utils.getFormattedCalendarString(tmpCalendar));
            }
            catch (Exception e) {
                logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer startInstance (2)- " + submitter + " - id=" + transferId));
                e.printStackTrace();
            }
            SchedulerUtils.updateStatusAndErrors(transferId, agent, "STANDBY", null);
        }
    }

    public static Types.TransferOptions fillTransferOptions(TransferOptions options) {
        Types.TransferOptions stubOptions = new Types.TransferOptions();
        stubOptions.setOverwrite(options.isOverwriteFile());
        stubOptions.setStorageType(options.getType());
        stubOptions.setTransferTimeout(options.getTransferTimeout());
        int size = 0;
        if (options.isCovertFile()) {
            ++size;
        }
        if (options.isUnzipFile()) {
            ++size;
        }
        if (options.isDeleteOriginalFile()) {
            ++size;
        }
        if (size != 0) {
            int i = 0;
            Types.postProcessType[] type = new Types.postProcessType[size];
            if (options.isUnzipFile()) {
                type[i] = Types.postProcessType.FileUnzip;
                ++i;
            }
            if (options.isCovertFile()) {
                type[i] = Types.postProcessType.FileConversion;
                stubOptions.setConversionType(options.getConversionType().name());
                ++i;
            }
            if (options.isDeleteOriginalFile()) {
                type[i] = Types.postProcessType.OriginalFileRemove;
            }
            stubOptions.setPostProcess(Arrays.asList(type));
        }
        if (options.getType().name().compareTo(Types.storageType.StorageManager.name()) == 0) {
            stubOptions.setStorageManagerDetails(options.getStorageManagerDetails());
        }
        return stubOptions;
    }
}

