/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.sis;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.xml.XML;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocationBuilder;
import org.gcube.spatial.data.sdi.plugins.SDIAbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisPlugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(SisPlugin.class);
    File tmp = null;
    DataTransferContext ctx;
    String publicCatalogLocation;

    public SisPlugin(PluginInvocation invocation, DataTransferContext ctx, String publicCatalogLocation) {
        super(invocation);
        this.ctx = ctx;
        this.publicCatalogLocation = publicCatalogLocation;
    }

    public void cleanup() throws PluginCleanupException {
        try {
            if (this.tmp != null) {
                this.tmp.delete();
            }
        }
        catch (Throwable t) {
            throw new PluginCleanupException("Unable to delete tmp file " + (this.tmp == null ? this.tmp : this.tmp.getAbsolutePath()), t);
        }
    }

    public ExecutionReport run() throws PluginExecutionException {
        try {
            Map params = this.invocation.getParameters();
            String dataStorePath = (String)params.get("SOURCE_FILE");
            String category = (String)params.get("GEONETWORK_CATEGORY");
            String stylesheet = (String)params.get("GEONETWORK_STYLESHEET");
            File dataStore = new File(dataStorePath);
            log.debug("Extracting meta from {} ", (Object)dataStore.getAbsolutePath());
            org.opengis.metadata.Metadata meta = SisPlugin.getMetaFromFile(dataStore);
            this.tmp = File.createTempFile("tmp_meta_", ".xml");
            XML.marshal((Object)meta, (File)this.tmp);
            Metadata metadataInterface = (Metadata)SDIAbstractPlugin.metadata().build();
            String hostname = this.ctx.getCtx().container().configuration().hostname();
            String filename = dataStore.getName();
            String catalog = this.getCatalogFromPath(dataStorePath);
            HashSet invocations = new TemplateInvocationBuilder().threddsOnlineResources(hostname, filename, catalog).get();
            MetadataPublishOptions options = new MetadataPublishOptions((Set)invocations);
            options.setGeonetworkCategory(category);
            options.setGeonetworkStyleSheet(stylesheet);
            MetadataReport report = metadataInterface.pushMetadata(this.tmp, options);
            log.debug("Metadata report is {} ", (Object)report);
            return new ExecutionReport(this.invocation, "Published/Updated meta with id : " + report.getPublishedID() + " , UUID " + report.getPublishedUUID(), ExecutionReport.ExecutionReportFlag.SUCCESS);
        }
        catch (DataStoreException e) {
            log.error("Unable to parse source ", (Throwable)e);
            throw new PluginExecutionException("Unable to extract metadata.", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Unexpected error while generating metadata.", t);
            throw new PluginExecutionException("Unexpected error while generating meta.", t);
        }
    }

    public static final org.opengis.metadata.Metadata getMetaFromFile(Object dataStore) throws UnsupportedStorageException, DataStoreException {
        return DataStores.open((Object)dataStore).getMetadata();
    }

    private String getCatalogFromPath(String path) {
        return SisPlugin.getCatalogFromPath(path, this.publicCatalogLocation);
    }

    public static String getCatalogFromPath(String path, String publicCatalogLocation) {
        log.debug("Getting catalog from path {} ", (Object)path);
        String catalog = path.substring(publicCatalogLocation.length());
        if (catalog.contains("/")) {
            catalog = catalog.substring(0, catalog.lastIndexOf("/"));
            log.debug("Subcatalog found {} ", (Object)catalog);
        } else {
            log.debug("No catalog found");
            catalog = null;
        }
        return catalog;
    }
}

