package org.gcube.data.transfer.plugins.thredds.catalog;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPluginFactory;
import org.gcube.data.transfer.plugin.fails.ParameterException;
import org.gcube.data.transfer.plugin.fails.PluginInitializationException;
import org.gcube.data.transfer.plugin.fails.PluginShutDownException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class RegisterCatalogPluginFactory extends AbstractPluginFactory<RegisterCatalogPlugin>{

	static final String PLUGIN_ID="REGISTER_CATALOG";
	public static final String CATALOG_FILE="CATALOG_FILE";
	public static final String CATALOG_REFERENCE="CATALOG_REFERENCE";
	

	static final Map<String,String> PARAMETERS_DESCRIPTION= new HashMap<String,String>();

	static{		
		PARAMETERS_DESCRIPTION.put(CATALOG_REFERENCE, "[String value] The reference value under which the passed catalog should be registered.");
	}
	
	@Override
	public PluginInvocation checkInvocation(PluginInvocation arg0, String arg1) throws ParameterException {
		log.debug("Checking invocation {} ",arg0);
		Map<String,String> params=arg0.getParameters();
		if(params==null||params.isEmpty()||(!params.containsKey(CATALOG_REFERENCE))||(params.get(CATALOG_REFERENCE)==null))
			throw new ParameterException(CATALOG_REFERENCE + "parameter is mandatory.");
		arg0.getParameters().put(CATALOG_FILE, arg1);
		return arg0;
	}

	@Override
	public RegisterCatalogPlugin createWorker(PluginInvocation arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDescription() {
		return String.format("Registers a catalog file as <%s> under main thredds catalog.", CATALOG_REFERENCE);
	}

	@Override
	public String getID() {
		return PLUGIN_ID;
	}

	@Override
	public Map<String, String> getParameters() {
		return PARAMETERS_DESCRIPTION;
	}

	@Override
	public boolean init(DataTransferContext arg0) throws PluginInitializationException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean shutDown() throws PluginShutDownException {
		// TODO Auto-generated method stub
		return false;
	}

	
	
}
