/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.thredds;

import org.gcube.data.transfer.plugin.fails.PluginInitializationException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.data.transfer.plugins.thredds.ThreddsInitDetails;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commons {
    private static final Logger log = LoggerFactory.getLogger(Commons.class);

    public static ThreddsInitDetails getThreddsInitDetails(DataTransferContext ctx) throws PluginInitializationException {
        log.trace("Loading configuration .. ");
        String threddsContentRoot = null;
        for (ApplicationConfiguration app : ctx.getCtx().container().configuration().apps()) {
            log.debug("Found app {} ", (Object)app.context());
            if (!app.context().equals("thredds") && !app.context().equals("/thredds")) continue;
            threddsContentRoot = app.persistence().location();
            log.info("Thredds catalog base path from Context is {} ", (Object)threddsContentRoot);
        }
        if (threddsContentRoot == null) {
            throw new PluginInitializationException("No Thredds instance found in context");
        }
        ThreddsInitDetails details = new ThreddsInitDetails(threddsContentRoot, threddsContentRoot + "/public/netcdf/", threddsContentRoot + "/catalog.xml");
        log.trace("ThreddsInitDeteails will be {}", (Object)details);
        return details;
    }
}

