/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.thredds.catalog;

import java.io.File;
import java.util.Map;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.data.transfer.plugins.thredds.ThreddsInstanceManager;
import org.gcube.data.transfer.plugins.thredds.XMLCatalogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterCatalogPlugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(RegisterCatalogPlugin.class);
    private ThreddsInstanceManager instanceManager;

    public RegisterCatalogPlugin(PluginInvocation invocation, ThreddsInstanceManager instanceManager) {
        super(invocation);
        this.instanceManager = instanceManager;
    }

    public void cleanup() throws PluginCleanupException {
    }

    public ExecutionReport run() throws PluginExecutionException {
        try {
            Map params = this.invocation.getParameters();
            String catalogFile = (String)params.get("CATALOG_FILE");
            if (catalogFile.contains(" ")) {
                throw new PluginExecutionException("Invalid catalog filename " + catalogFile);
            }
            String catalogReference = (String)params.get("CATALOG_REFERENCE");
            log.trace("Registering {} as {}", (Object)catalogFile, (Object)catalogReference);
            XMLCatalogHandler handler = this.instanceManager.mainCatalogHandler();
            handler.registerCatalog(new File(catalogFile), catalogReference);
            handler.close();
            this.instanceManager.clearCache();
            return new ExecutionReport(this.invocation, "Registered catalog entry " + catalogReference, ExecutionReport.ExecutionReportFlag.SUCCESS);
        }
        catch (Throwable t) {
            log.error("Unable to register catalog.", t);
            throw new PluginExecutionException("Unable to register catalog.", t);
        }
    }
}

