/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.resolver.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResolver
extends HttpServlet {
    String uri = null;
    String fileName = null;
    String contentType = null;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HttpResolver.class);

    public void init(ServletConfig conf) throws ServletException {
        Handler.activateProtocol();
        super.init(conf);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int index;
        logger.info("The http session id is: " + request.getSession().getId());
        logger.debug("Original URI = " + this.uri);
        this.uri = request.getParameter("smp-uri");
        if (this.uri == null || this.uri.equals("")) {
            logger.debug("URI not found");
            response.sendError(404);
            return;
        }
        this.fileName = request.getParameter("fileName");
        if (this.fileName == null || this.fileName.equals("")) {
            logger.debug("fileName not found");
            this.fileName = null;
        }
        this.contentType = request.getParameter("contentType");
        if (this.contentType == null || this.contentType.equals("")) {
            logger.debug("contentType not found");
            this.contentType = null;
        }
        if ((index = this.uri.indexOf("?")) != -1) {
            String firsPart = this.uri.substring(0, index);
            String secondPart = this.uri.substring(index + 1);
            secondPart.replace(" ", "+");
            this.uri = firsPart + "?" + secondPart;
        } else {
            this.uri = this.uri.replace(" ", "+");
        }
        logger.debug("URI = " + this.uri);
        try {
            ServletOutputStream out = response.getOutputStream();
            if (this.fileName != null) {
                response.addHeader("content-disposition", "attachment; filename=" + this.fileName);
            } else {
                response.addHeader("content-disposition", "attachment; filename=fromStorageManager");
            }
            if (this.contentType != null) {
                response.setContentType(this.contentType);
            } else {
                response.setContentType("unknown/unknown");
            }
            URL url = new URL(null, this.uri, (URLStreamHandler)new /* Unavailable Anonymous Inner Class!! */);
            URLConnection uc = null;
            InputStream in = null;
            try {
                uc = url.openConnection();
                in = uc.getInputStream();
            }
            catch (Exception e) {
                response.sendError(404);
                logger.error("Exception:", (Throwable)e);
                return;
            }
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            out.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception:", (Throwable)e);
            response.sendError(404);
            return;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }
}

