/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.UUID;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.AnsibleWorker;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.AnsibleBridge;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.Configuration;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.service.DMPMJob;
import org.gcube.dataanalysis.dataminer.poolmanager.util.CheckMethod;
import org.gcube.dataanalysis.dataminer.poolmanager.util.NotificationHelper;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNUpdater;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SendMail;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.EMailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DMPMJob {
    private Configuration configuration;
    private String dmpmHomeDirectory;
    private SVNUpdater svnUpdater;
    private File jobLogs;
    private String id;
    private Algorithm algorithm;
    private Cluster cluster;
    private String vREName;
    private String category;
    private String algorithm_type;
    private Logger logger = LoggerFactory.getLogger(DMPMJob.class);

    public DMPMJob(SVNUpdater svnUpdater, Configuration configuration, Algorithm algorithm, Cluster cluster, String vREName, String category, String algorithm_type) {
        this.configuration = configuration;
        this.algorithm = algorithm;
        this.cluster = cluster;
        this.vREName = vREName;
        this.category = category;
        this.algorithm_type = algorithm_type;
        this.svnUpdater = svnUpdater;
        this.dmpmHomeDirectory = new String(System.getProperty("user.home") + File.separator + "dataminer-pool-manager");
        this.id = UUID.randomUUID().toString();
        this.jobLogs = new File(this.dmpmHomeDirectory + File.separator + "jobs");
        this.jobLogs.mkdirs();
    }

    public String start() {
        this.setStatusInformation(STATUS.PROGRESS);
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return this.id;
    }

    protected AnsibleWorker createWorker(Algorithm algo, Cluster dataminerCluster, boolean includeAlgorithmDependencies, String user) {
        AnsibleBridge ansibleBridge = new AnsibleBridge(this.dmpmHomeDirectory);
        try {
            return ansibleBridge.createWorker(algo, dataminerCluster, includeAlgorithmDependencies, user);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setStatusInformation(STATUS exitStatus) {
        try {
            File statusFile = new File(this.jobLogs, this.id + "_exitStatus");
            PrintWriter writer = new PrintWriter(statusFile, "UTF-8");
            writer.println(STATUS.access$000((STATUS)exitStatus));
            writer.close();
        }
        catch (Exception e) {
            this.logger.error("Unable to update exit status file with status " + STATUS.access$000((STATUS)exitStatus), (Throwable)e);
        }
    }

    private void updateLogFile(File logFile, String message) {
        try {
            PrintWriter writer = new PrintWriter(logFile, "UTF-8");
            writer.print(message);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error("Unable to log the error message: " + message, (Throwable)e);
        }
    }

    protected abstract void execute();

    private boolean preInstallation(SendMail sm, NotificationHelper nh, File logFile) throws SVNException, EMailException {
        this.logger.debug("Checking dependencies...");
        Collection undefinedDependencies = this.svnUpdater.getUndefinedDependencies(this.svnUpdater.getDependencyFile(this.algorithm.getLanguage()), this.algorithm.getDependencies());
        if (!undefinedDependencies.isEmpty()) {
            this.logger.debug("Some dependencies are not defined");
            String message = "Following dependencies are not defined:\n";
            for (String n : undefinedDependencies) {
                message = message + "\n" + n + "\n";
            }
            this.setStatusInformation(STATUS.FAILED);
            String errorMessage = nh.getFailedBody(message + "\n\n" + this.buildInfo());
            this.updateLogFile(logFile, errorMessage);
            sm.sendNotification(nh.getFailedSubject() + " for " + this.algorithm.getName() + " algorithm", errorMessage);
            return false;
        }
        return true;
    }

    private void installation(SendMail sm, NotificationHelper nh, CheckMethod methodChecker, File logFile) throws Exception {
        methodChecker.deleteFiles(this.algorithm);
        int ret = this.executeAnsibleWorker(this.createWorker(this.algorithm, this.cluster, false, "root"), logFile);
        System.out.println("Return code= " + ret);
        if (ret != 0) {
            this.logger.debug("Ansible work failed, return code " + ret);
            this.setStatusInformation(STATUS.FAILED);
            String errorMessage = nh.getFailedBody("Installation failed. Return code=" + ret) + "\n\n" + this.buildInfo();
            sm.sendNotification(nh.getFailedSubject() + " for " + this.algorithm.getName() + " algorithm", errorMessage);
        } else if (ret == 0) {
            this.logger.debug("Operation completed");
            this.logger.debug("Checking the method...");
            if (methodChecker.checkMethod(this.configuration.getHost(), SecurityTokenProvider.instance.get()) && methodChecker.algoExists(this.algorithm)) {
                this.logger.debug("Method OK and algo exists");
                System.out.println("Interface check ok!");
                System.out.println("Both the files exist at the correct path!");
                this.svnUpdater.updateSVNAlgorithmList(this.algorithm, this.vREName, this.category, this.algorithm_type, this.algorithm.getFullname());
                this.setStatusInformation(STATUS.COMPLETED);
                sm.sendNotification(nh.getSuccessSubject() + " for " + this.algorithm.getName() + " algorithm", nh.getSuccessBody("\n\n" + this.buildInfo()));
                return;
            }
            this.logger.debug("Operation failed");
            this.setStatusInformation(STATUS.FAILED);
            sm.sendNotification(nh.getFailedSubject() + " for " + this.algorithm.getName() + " algorithm", nh.getFailedBody("\nInstallation completed but DataMiner Interface not working correctly or files " + this.algorithm.getName() + ".jar and " + this.algorithm.getName() + "_interface.jar not availables at the expected path") + "\n\n" + this.buildInfo());
        }
    }

    protected void execute(NotificationHelper nh, CheckMethod methodChecker) {
        SendMail sm = new SendMail();
        try {
            this.logger.debug("Pre installation operations");
            File logFile = new File(this.jobLogs, this.id);
            boolean preInstallationResponse = this.preInstallation(sm, nh, logFile);
            this.logger.debug("Pre installation operation completed with result " + preInstallationResponse);
            if (preInstallationResponse) {
                this.logger.debug("Installation...");
                this.installation(sm, nh, methodChecker, logFile);
                this.logger.debug("Installation completed");
            }
        }
        catch (EMailException eme) {
            this.logger.error("Operation failed and unable to send notification email", (Throwable)eme);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int executeAnsibleWorker(AnsibleWorker worker, File logFile) throws IOException, InterruptedException, SVNException {
        FileOutputStream fos = new FileOutputStream(logFile, true);
        PrintStream ps = new PrintStream(fos);
        return worker.execute(ps);
    }

    public String buildInfo() {
        return "\nAlgorithm details:\n\nUser: " + this.algorithm.getFullname() + "\nAlgorithm name: " + this.algorithm.getName() + "\nStaging DataMiner Host: " + this.configuration.getHost() + "\nCaller VRE: " + ScopeProvider.instance.get() + "\nTarget VRE: " + this.vREName + "\n";
    }
}

