/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.EMailException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class SendMail {
    public void sendNotification(String subject, String body) throws EMailException {
        String serviceAddress = this.getSocialService();
        if (!serviceAddress.endsWith("/")) {
            serviceAddress = serviceAddress + "/";
        }
        String requestForMessage = serviceAddress + "messages/writeMessageToUsers?gcube-token=" + SecurityTokenProvider.instance.get();
        requestForMessage = requestForMessage.replace("http://", "https://").replace(":80", "");
        try {
            subject = URLEncoder.encode(subject, "UTF-8");
            body = URLEncoder.encode(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EMailException((Throwable)e);
        }
        String requestParameters = "&sender=dataminer&recipients=" + this.getAdmins() + "&subject=" + subject + "&body=" + body;
        String response = this.sendPostRequest(requestForMessage, requestParameters);
        if (response == null) {
            throw new EMailException();
        }
    }

    public String username(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry entry = Constants.authorizationService().get(token);
        System.out.println(entry.getClientInfo().getId());
        return entry.getClientInfo().getId();
    }

    public String getSocialService() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        String a = ((GCoreEndpoint.Profile.Endpoint)((GCoreEndpoint)resources.get(0)).profile().endpointMap().get("jersey-servlet")).uri().toString();
        return a;
    }

    public String sendPostRequest(String endpoint, String requestParameters) {
        String data = requestParameters;
        try {
            String line;
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(data);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            return answer.toString();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getAdminRoles() throws Exception {
        String serviceAddress = this.getSocialService();
        serviceAddress = serviceAddress.endsWith("/") ? serviceAddress : serviceAddress + "/";
        serviceAddress = serviceAddress + "2/users/get-usernames-by-role?";
        serviceAddress = serviceAddress + "role-name=DataMiner-Manager&gcube-token=" + SecurityTokenProvider.instance.get();
        System.out.println("Url is " + serviceAddress);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet getReq = new HttpGet(serviceAddress);
        getReq.setHeader("accept", "application/json");
        getReq.setHeader("content-type", "application/json");
        System.out.println(EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity()));
        return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity());
    }

    public String getAdmins() {
        try {
            LinkedList<String> s = new LinkedList<String>();
            JSONObject obj = new JSONObject(this.getAdminRoles());
            JSONArray data = obj.getJSONArray("result");
            if (data != null) {
                String[] names = new String[data.length()];
                for (int i = 0; i < data.length(); ++i) {
                    names[i] = data.getString(i);
                    s.add(names[i]);
                }
                s.add(this.username(SecurityTokenProvider.instance.get()));
            }
            return ((Object)s).toString().replace("[", "").replace("]", "");
        }
        catch (Exception a) {
            return "ciro.formisano, lucio.lelii, roberto.cirillo, gianpaolo.coro, giancarlo.panichi, scarponi";
        }
    }

    public static void main(String[] args) throws Exception {
        SendMail sm = new SendMail();
        ScopeProvider.instance.set("/gcube/preprod/preVRE");
        SecurityTokenProvider.instance.set("2eceaf27-0e22-4dbe-8075-e09eff199bf9-98187548");
        System.out.println(sm.getAdmins());
    }
}

