/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.DMPMClientConfiguratorManager;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.EMailException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMail {
    private Logger logger = LoggerFactory.getLogger(SendMail.class);
    private final String WRITE_MESSAGE_ADDRESS_PATH = "messages/writeMessageToUsers?gcube-token=";
    private final String USER_ROLES_ADDRESS_PATH = "2/users/get-usernames-by-role?role-name=DataMiner-Manager&gcube-token=";
    private final String ENCODING = "UTF-8";
    private final String SENDER_PARAMETER_FORMAT = "&sender=dataminer&recipients=%s&subject=%s&body=%s";
    private final String SOCIAL_SERVICE_QUERY_CONDITION = "$resource/Profile/ServiceName/text() eq 'SocialNetworking'";
    private final String SOCIAL_SERVICE_URI = "jersey-servlet";
    private final String JSON_MIME_TYPE = "application/json";

    private String getRequestMessage(String addressPath) {
        String serviceAddress = this.getSocialService();
        StringBuilder requestMessageBuilder = new StringBuilder(serviceAddress);
        if (!serviceAddress.endsWith("/")) {
            requestMessageBuilder.append('/');
        }
        requestMessageBuilder.append(addressPath).append(SecurityTokenProvider.instance.get());
        String requestForMessage = requestMessageBuilder.toString();
        this.logger.debug("Request " + requestForMessage);
        return requestForMessage;
    }

    public void sendNotification(String subject, String body) throws EMailException {
        this.logger.debug("Sending mail notification for " + subject);
        this.logger.debug("Body " + body);
        try {
            subject = URLEncoder.encode(subject, "UTF-8");
            body = URLEncoder.encode(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EMailException((Throwable)e);
        }
        String requestForMessage = this.getRequestMessage("messages/writeMessageToUsers?gcube-token=");
        requestForMessage = requestForMessage.replace("http://", "https://").replace(":80", "");
        String requestParameters = String.format("&sender=dataminer&recipients=%s&subject=%s&body=%s", this.getAdmins(), subject, body);
        String response = this.sendPostRequest(requestForMessage, requestParameters);
        if (response == null) {
            throw new EMailException();
        }
    }

    public String username(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry entry = Constants.authorizationService().get(token);
        this.logger.debug(entry.getClientInfo().getId());
        return entry.getClientInfo().getId();
    }

    public String getSocialService() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        String a = ((GCoreEndpoint.Profile.Endpoint)((GCoreEndpoint)resources.get(0)).profile().endpointMap().get("jersey-servlet")).uri().toString();
        return a;
    }

    public String sendPostRequest(String endpoint, String requestParameters) {
        this.logger.debug("Sending post request");
        String data = requestParameters;
        try {
            String line;
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(data);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            this.logger.debug("Operation completed");
            String response = answer.toString();
            this.logger.debug("Response " + response);
            return response;
        }
        catch (MalformedURLException ex) {
            this.logger.error("Invalid URL", (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error("Error in the IO process", (Throwable)ex);
        }
        return null;
    }

    public String getAdminRoles() throws Exception {
        String serviceAddress = this.getRequestMessage("2/users/get-usernames-by-role?role-name=DataMiner-Manager&gcube-token=");
        this.logger.debug("Admin roles url is " + serviceAddress);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet getReq = new HttpGet(serviceAddress);
        getReq.setHeader("accept", "application/json");
        getReq.setHeader("content-type", "application/json");
        this.logger.info(EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity()));
        return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity());
    }

    public String getAdmins() {
        try {
            LinkedList<String> s = new LinkedList<String>();
            JSONObject obj = new JSONObject(this.getAdminRoles());
            JSONArray data = obj.getJSONArray("result");
            if (data != null) {
                String[] names = new String[data.length()];
                for (int i = 0; i < data.length(); ++i) {
                    names[i] = data.getString(i);
                    s.add(names[i]);
                }
                s.add(this.username(SecurityTokenProvider.instance.get()));
            }
            return ((Object)s).toString().replace("[", "").replace("]", "");
        }
        catch (Exception a) {
            return DMPMClientConfiguratorManager.getInstance().getDefaultAdmins();
        }
    }

    public static void main(String[] args) throws Exception {
        SendMail sm = new SendMail();
        ScopeProvider.instance.set("/gcube/preprod/preVRE");
        SecurityTokenProvider.instance.set("2eceaf27-0e22-4dbe-8075-e09eff199bf9-98187548");
        System.out.println(sm.getAdmins());
    }
}

