/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;

public class ListDBInfo
extends StandardLocalInfraAlgorithm {
    private static final String PLATFORM_VERSION = "Platform Version ";
    private static final String DIALECT_NAME = "Dialect Name ";
    private static final String DATABASE_NAME = "Database Name ";
    private static final String DRIVER_NAME = "Driver Name ";
    private static final String URL_NAME = "URL ";
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private String resourceName = null;
    private List<DBResource.AccessPoint> ap = new ArrayList<DBResource.AccessPoint>();
    private String platformVersion = "";

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"In ListDBInfo->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->scope set by config object: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to view information about one chosen resource of Database Type in the Infrastructure";
    }

    protected void process() throws Exception, IOException, IllegalStateException, DiscoveryException, InvalidResultException {
        AnalysisLogger.getLogger().debug((Object)"In ListDBInfo->Processing");
        try {
            List<DBResource.AccessPoint> apInfo = this.retrieveInfo();
            AnalysisLogger.getLogger().debug((Object)("access point dimension: " + apInfo.size()));
            for (int i = 0; i < apInfo.size(); ++i) {
                String name = DATABASE_NAME + (i + 1);
                PrimitiveType DBName = new PrimitiveType(String.class.getName(), (Object)apInfo.get(i).getDatabaseName(), PrimitiveTypes.STRING, name, name);
                this.map.put(name, (StatisticalType)DBName);
                AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->Database Name: " + apInfo.get(i).getDatabaseName()));
                String urlId = URL_NAME + (i + 1);
                PrimitiveType url = new PrimitiveType(String.class.getName(), (Object)apInfo.get(i).address(), PrimitiveTypes.STRING, urlId, urlId);
                this.map.put(urlId, (StatisticalType)url);
                AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->URL: " + apInfo.get(i).address()));
                String driverId = DRIVER_NAME + (i + 1);
                PrimitiveType driver = new PrimitiveType(String.class.getName(), (Object)apInfo.get(i).getDriver(), PrimitiveTypes.STRING, driverId, driverId);
                this.map.put(driverId, (StatisticalType)driver);
                AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->Driver Name: " + apInfo.get(i).getDriver()));
                String dialectId = DIALECT_NAME + (i + 1);
                PrimitiveType dialect = new PrimitiveType(String.class.getName(), (Object)apInfo.get(i).getDialect(), PrimitiveTypes.STRING, dialectId, dialectId);
                this.map.put(dialectId, (StatisticalType)dialect);
                AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->Dialect Name: " + apInfo.get(i).getDialect()));
                String platformId = PLATFORM_VERSION + (i + 1);
                PrimitiveType platformVersionValue = new PrimitiveType(String.class.getName(), (Object)this.platformVersion, PrimitiveTypes.STRING, platformId, platformId);
                this.map.put(platformId, (StatisticalType)platformVersionValue);
                AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->Platform Version: " + this.platformVersion));
            }
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In ListDBInfo-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In ListDBInfo-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In ListDBInfo-> ERROR " + e2.getMessage()));
            throw e2;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In ListDBInfo-> Exception " + e4.getMessage()));
            throw e4;
        }
    }

    protected void setInputParameters() {
        this.addStringInput("ResourceName", "The name of the resource", "");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In ListDBInfo->Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In ListDBInfo->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    private List<DBResource.AccessPoint> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->number of database resources: " + resources.size()));
        for (int i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.platformVersion = ((DBResource)resources.get(i)).getPlatformVersion();
            this.normalizeDBInfo((DBResource)resources.get(i));
            this.ap = ((DBResource)resources.get(i)).getAccessPoints();
            break;
        }
        return this.ap;
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In ListDBInfo->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }
}

