/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;

public class ListNames
extends StandardLocalInfraAlgorithm {
    private static final String RESOURCE_NAME = "Resource Name ";
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"In ListNames->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In ListNames->scope set by config object: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to view the available database resources names in the Infrastructure";
    }

    protected void process() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"In ListNames->Processing");
        try {
            List<DBResource> resources = this.retrieveResources();
            ArrayList<String> listnames = new ArrayList<String>();
            for (int i = 0; i < resources.size(); ++i) {
                String name = RESOURCE_NAME + (i + 1);
                PrimitiveType val = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, name, name);
                AnalysisLogger.getLogger().debug((Object)("In ListNames->Resource's name: " + resources.get(i).getResourceName()));
                listnames.add(resources.get(i).getResourceName());
                val.setContent(listnames.get(i));
                this.map.put(name, (StatisticalType)val);
            }
            AnalysisLogger.getLogger().debug((Object)("In ListNames->Output Map Size: " + this.map.size()));
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In ListNames-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In ListNames-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In ListNames-> ERROR " + e2.getMessage()));
            throw e2;
        }
    }

    protected void setInputParameters() {
        this.addStringInput("MaxNumber", "Max Number of Resources (-1 for all)", "-1");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In ListNames->Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In ListNames->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    private List<DBResource> retrieveResources() throws IllegalStateException, DiscoveryException, InvalidResultException {
        AnalysisLogger.getLogger().debug((Object)"In ListNames->retrieving resources");
        List<DBResource> resources = new ArrayList();
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In ListNames->number of database resources: " + resources.size()));
        return resources;
    }
}

