/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.resources;

import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.resources.processing.Normalizer;

@XmlRootElement(name="Resource")
public class DBResource {
    private String ResourceName;
    private String PlatformName;
    private String PlatformVersion;
    private String HostedOn;
    private String Port = null;
    private String dbguessed = null;
    private List<AccessPoint> ap = null;
    @XmlElement(name="ID")
    private String id;
    @XmlElementRef
    private Profile profile;

    public String getID() {
        if (this.id == null) {
            this.id = "";
        }
        return this.id;
    }

    public String getPort() {
        if (this.Port == null) {
            this.Port = "";
        }
        return this.Port;
    }

    public void setPort(String value) {
        this.Port = value;
    }

    public String getResourceName() {
        this.ResourceName = this.profile.getname().trim();
        return this.ResourceName;
    }

    public String getHostedOn() {
        this.HostedOn = this.profile.getHostedOn();
        return this.HostedOn;
    }

    public String getPlatformName() {
        this.PlatformName = this.profile.getPlatformName();
        if (this.PlatformName.contains(" ")) {
            this.PlatformName = this.PlatformName.trim();
        }
        return this.PlatformName;
    }

    public void setPlatformName(String name) {
        this.profile.platform.name = name;
    }

    public String getPlatformVersion() {
        this.PlatformVersion = this.profile.getPlatformVersion();
        return this.PlatformVersion;
    }

    public void setHostedOn(String value) {
        this.HostedOn = value;
    }

    public String getDBguessed() {
        return this.dbguessed;
    }

    public void setDBguessed(String name) {
        this.dbguessed = name;
    }

    public void normalize(int index) throws Exception {
        Normalizer.normalize(this, index);
    }

    public List<AccessPoint> getAccessPoints() throws Exception {
        if (this.ap == null) {
            List<AccessPoint> data = this.profile.accessPoints();
            this.ap = this.getNoDuplicatedAccessPointsItems(data);
        }
        return this.ap;
    }

    private List<AccessPoint> getNoDuplicatedAccessPointsItems(List<AccessPoint> data) throws Exception {
        ArrayList<AccessPoint> result = new ArrayList<AccessPoint>(data);
        for (int j = 0; j < result.size(); ++j) {
            AccessPoint item = (AccessPoint)result.get(j);
            ArrayList ap = new ArrayList(result.subList(j, result.size()));
            ap.remove(item);
            for (int i = 0; i < ap.size(); ++i) {
                if (!item.equals((AccessPoint)ap.get(i))) continue;
                result.remove(ap.get(i));
                AnalysisLogger.getLogger().debug((Object)"In class DBResource-> duplicated access point element founded and removed");
            }
        }
        return result;
    }

    @XmlRootElement(name="Property")
    public static class Property {
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Value")
        private String value;

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public String setvalue(String val) {
            this.value = val;
            return this.value;
        }
    }

    @XmlRootElement(name="AccessData")
    public static class AccessData {
        @XmlElement(name="Username")
        private String username;
        @XmlElement(name="Password")
        private String password;

        public String username() {
            if (this.username == null || this.username.equals("")) {
                this.username = "gcube";
            }
            return this.username;
        }

        public String password() {
            if (this.password == null || this.password.equals("")) {
                this.password = "d4science";
            }
            return this.password;
        }
    }

    @XmlRootElement(name="Endpoint")
    public static class Endpoint {
        @XmlAttribute(name="EntryName")
        private String name;
        @XmlValue
        private String address;

        public String name() {
            return this.name;
        }

        public String address() {
            if (this.address == null) {
                this.address = "";
            }
            return this.address;
        }
    }

    @XmlRootElement(name="Interface")
    public static class Interface {
        @XmlElementRef
        private Endpoint endpoint = new Endpoint();

        public Endpoint endpoint() {
            return this.endpoint;
        }
    }

    @XmlRootElement(name="AccessPoint")
    public static class AccessPoint {
        private String endpoint;
        private String username;
        private String password;
        private String DatabaseName = null;
        private String Driver = null;
        private String Dialect = null;
        private String MaxConnections = null;
        private String schema = null;
        private String tableSpaceCount = null;
        private String tableSpacePrefix = null;
        private HashMap<String, String> auxiliaryProperties = new HashMap();
        @XmlElementRef
        private Interface itfce = new Interface();
        @XmlElementRef
        private AccessData accessData = new AccessData();
        @XmlElementWrapper(name="Properties")
        @XmlElementRef
        private List<Property> properties = new ArrayList<Property>();
        @XmlElement(name="Description")
        private String description;

        public String name() {
            return this.itfce.endpoint().name();
        }

        public String address() {
            this.endpoint = this.itfce.endpoint().address().trim();
            if (this.endpoint == null) {
                this.endpoint = "";
            }
            return this.endpoint;
        }

        public void setUrl(String value) {
            this.itfce.endpoint.address = value;
            this.endpoint = this.itfce.endpoint.address.trim();
        }

        public String getUsername() {
            this.username = this.accessData.username();
            return this.username;
        }

        public String getPassword() throws Exception {
            String pwd = this.accessData.password();
            this.password = StringEncrypter.getEncrypter().decrypt(pwd, new Key[0]);
            return this.password;
        }

        public String getDescription() {
            if (this.description == null || this.description.equals("")) {
                this.description = "jdbc connection url";
            }
            return this.description;
        }

        public String getDatabaseName() {
            if (this.properties.size() == 0) {
                Property p = new Property();
                p.name = "dbname";
                p.value = "";
                this.properties.add(p);
                this.DatabaseName = "";
                return "";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("dbname") && !this.properties.get(i).name().toLowerCase().contains("databasename") && !this.properties.get(i).name().toLowerCase().contains("database")) continue;
                this.DatabaseName = this.properties.get(i).value();
            }
            if (this.DatabaseName == null) {
                Property p = new Property();
                p.name = "dbname";
                p.value = "";
                this.properties.add(p);
                this.DatabaseName = "";
                return this.DatabaseName;
            }
            return this.DatabaseName;
        }

        public void setDatabaseName(String value) {
            this.DatabaseName = value;
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("dbname") && !this.properties.get(i).name().toLowerCase().contains("databasename") && !this.properties.get(i).name().toLowerCase().contains("database")) continue;
                this.DatabaseName = this.properties.get(i).setvalue(value);
                AnalysisLogger.getLogger().debug((Object)("In class DBResource->setting the database's name to value : " + this.DatabaseName));
            }
        }

        public String getDriver() {
            if (this.properties.size() == 0) {
                Property p = new Property();
                p.name = "driver";
                p.value = "";
                this.properties.add(p);
                this.Driver = "";
                return "";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("driver")) continue;
                this.Driver = this.properties.get(i).value();
            }
            if (this.Driver == null) {
                Property p = new Property();
                p.name = "driver";
                p.value = "";
                this.properties.add(p);
                this.Driver = "";
                return this.Driver;
            }
            return this.Driver;
        }

        public void SetDriver(String value) {
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("driver")) continue;
                this.Driver = this.properties.get(i).setvalue(value);
                AnalysisLogger.getLogger().debug((Object)("In class DBResource->setting the driver's name to value : " + this.Driver));
            }
        }

        public String getDialect() {
            if (this.properties.size() == 0) {
                Property p = new Property();
                p.name = "dialect";
                p.value = "";
                this.properties.add(p);
                this.Dialect = "";
                return "";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("dialect")) continue;
                this.Dialect = this.properties.get(i).value();
            }
            if (this.Dialect == null) {
                Property p = new Property();
                p.name = "dialect";
                p.value = "";
                this.properties.add(p);
                this.Dialect = "";
                return this.Dialect;
            }
            return this.Dialect;
        }

        public void SetDialect(String value) {
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().toLowerCase().contains("dialect")) continue;
                this.Dialect = this.properties.get(i).setvalue(value);
                AnalysisLogger.getLogger().debug((Object)("In class DBResource->Setting the dialect: " + this.Dialect));
            }
        }

        public String getMaxConnections() {
            if (this.properties.size() == 0) {
                this.MaxConnections = "2";
                return "2";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().equals("maxConnection")) continue;
                this.MaxConnections = this.properties.get(i).value();
            }
            if (this.MaxConnections == null) {
                this.MaxConnections = "2";
                return "2";
            }
            return this.MaxConnections;
        }

        public String getSchema() {
            if (this.properties.size() == 0) {
                this.schema = "public";
                return "public";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().equals("schema")) continue;
                this.schema = this.properties.get(i).value();
            }
            if (this.schema == null) {
                this.schema = "public";
                return "public";
            }
            return this.schema;
        }

        public String getTableSpaceCount() {
            if (this.properties.size() == 0) {
                this.tableSpaceCount = "0";
                return "0";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().equals("tableSpaceCount")) continue;
                this.tableSpaceCount = this.properties.get(i).value();
            }
            if (this.tableSpaceCount == null) {
                this.tableSpaceCount = "0";
                return "0";
            }
            return this.tableSpaceCount;
        }

        public String getTableSpacePrefix() {
            if (this.properties.size() == 0) {
                this.tableSpacePrefix = "";
                return "";
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.properties.get(i).name().equals("tableSpacePrefix")) continue;
                this.tableSpacePrefix = this.properties.get(i).value();
            }
            if (this.tableSpacePrefix == null) {
                this.tableSpacePrefix = "";
                return "";
            }
            return this.tableSpacePrefix;
        }

        public HashMap<String, String> getAuxiliaryProperties() {
            if (this.properties.size() == 0) {
                return this.auxiliaryProperties;
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                String AuxiliaryProperty;
                if (this.properties.get(i).name().equals("aquamapsWorldTable")) {
                    AuxiliaryProperty = this.properties.get(i).value();
                    this.auxiliaryProperties.put("aquamapsWorldTable", AuxiliaryProperty);
                }
                if (!this.properties.get(i).name().equals("aquamapsDataStore")) continue;
                AuxiliaryProperty = this.properties.get(i).value();
                this.auxiliaryProperties.put("aquamapsDataStore", AuxiliaryProperty);
            }
            return this.auxiliaryProperties;
        }

        public boolean equals(AccessPoint obj) throws Exception {
            return this.address().equals(obj.address()) && this.getUsername().equals(obj.getUsername()) && this.getPassword().equals(obj.getPassword());
        }
    }

    @XmlRootElement(name="Platform")
    public static class Platform {
        private String version;
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Version")
        private String Version;
        @XmlElement(name="MinorVersion")
        private String minorVersion;
        @XmlElement(name="RevisionVersion")
        private String revisionVersion;

        public String getVersion() {
            if (this.Version == null || this.Version.equals("")) {
                this.Version = "";
                this.minorVersion = "";
                this.revisionVersion = "";
                this.version = this.Version + "." + this.minorVersion + "." + this.revisionVersion;
            } else {
                this.version = this.Version;
                if (this.minorVersion != null && !this.minorVersion.equals("")) {
                    this.version = this.version.concat(".").concat(this.minorVersion);
                    if (this.revisionVersion != null && !this.revisionVersion.equals("")) {
                        this.version = this.version.concat(".").concat(this.revisionVersion);
                    }
                }
            }
            return this.version;
        }

        public String getName() {
            return this.name;
        }
    }

    @XmlRootElement(name="RunTime")
    public static class Runtime {
        @XmlElement(name="HostedOn")
        private String hostedOn;

        public String getHostedOn() {
            if (this.hostedOn == null) {
                this.hostedOn = "";
            }
            return this.hostedOn;
        }
    }

    @XmlRootElement(name="Profile")
    static class Profile {
        @XmlElement(name="Name")
        private String name;
        @XmlElementRef
        private Platform platform;
        @XmlElementRef
        private Runtime runtime;
        @XmlElementRef
        private List<AccessPoint> accessPoints = new ArrayList<AccessPoint>();

        Profile() {
        }

        public String getname() {
            if (this.name == null) {
                this.name = "";
            }
            return this.name;
        }

        public List<AccessPoint> accessPoints() {
            return this.accessPoints;
        }

        public String getHostedOn() {
            return this.runtime.getHostedOn().trim();
        }

        public String getPlatformName() {
            return this.platform.getName();
        }

        public String getPlatformVersion() {
            return this.platform.getVersion();
        }
    }
}

