/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.structure;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public abstract class AbstractTableStructure {
    protected List<String> ColumnNames = new ArrayList<String>();
    protected List<String> TypesList = new ArrayList<String>();
    protected List<Integer> TypesLengths = new ArrayList<Integer>();
    protected List<String> DefaultValues = new ArrayList<String>();
    protected List<String> CompleteTypes = new ArrayList<String>();
    protected List<String> ColumnKeys = new ArrayList<String>();
    protected List<String> UniqueKeys = new ArrayList<String>();
    protected List<String> ForeignKeys = new ArrayList<String>();
    protected List<String> Indexes = new ArrayList<String>();
    protected List<Boolean> IsNullables = new ArrayList<Boolean>();
    protected String databaseName;
    protected String charset;
    protected String tableName;
    protected static String createTableQueryElement = "\"%1$s\" %2$s %3$s %4$s";
    protected static String defaultTableQueryElement = "DEFAULT %1$s";
    protected static String createTableQuery = "CREATE TABLE %1$s ( %2$s );";
    protected static String primaryKeyStatement = "PRIMARY KEY";
    protected static String uniqueKeyStatement = "UNIQUE";
    protected static String foreignKeyStatement = "FOREIGN KEY";

    protected abstract void buildStructure(SessionFactory var1) throws Exception;

    protected abstract String getQueryForTableStructure(SessionFactory var1) throws Exception;

    protected abstract String getQueryForIndexes(SessionFactory var1) throws Exception;

    public AbstractTableStructure(String Databasename, String TableName, SessionFactory dbSession, boolean buildStructure) throws Exception {
        this.tableName = TableName;
        this.databaseName = Databasename;
        if (buildStructure) {
            this.buildStructure(dbSession);
        }
    }

    public AbstractTableStructure(String Databasename, String TableName, SessionFactory dbSession) throws Exception {
        this(Databasename, TableName, dbSession, true);
    }

    public String buildUpCreateTable() {
        int numOfElements = this.ColumnNames.size();
        StringBuffer elementsBuffer = new StringBuffer();
        for (int i = 0; i < numOfElements; ++i) {
            String nullable = "";
            if (!this.IsNullables.get(i).booleanValue()) {
                nullable = "NOT NULL";
            }
            String defaultvalue = "";
            if (this.DefaultValues.size() != 0 && this.DefaultValues.get(i) != null && this.DefaultValues.get(i).trim().length() > 0 && nullable.equals("NOT NULL")) {
                defaultvalue = this.DefaultValues.get(i);
                defaultvalue = String.format(defaultTableQueryElement, defaultvalue);
            }
            String createStatementElement = String.format(createTableQueryElement, this.ColumnNames.get(i), this.TypesList.get(i), nullable, defaultvalue);
            elementsBuffer.append(createStatementElement);
            if (i >= numOfElements - 1) continue;
            elementsBuffer.append(",");
        }
        elementsBuffer.append(this.buildUPConstraint(primaryKeyStatement, this.ColumnKeys));
        elementsBuffer.append(this.buildUPConstraint(uniqueKeyStatement, this.UniqueKeys));
        elementsBuffer.append(this.buildUPConstraint(foreignKeyStatement, this.ForeignKeys));
        String createStatement = String.format(createTableQuery, this.tableName, elementsBuffer.toString(), this.charset);
        AnalysisLogger.getLogger().debug((Object)("AbstractTableStructure->Create Table Query: " + createStatement));
        return createStatement;
    }

    private String buildUPConstraint(String statement, List<String> Keys) {
        StringBuffer elementsBuffer = new StringBuffer();
        int numKeys = Keys.size();
        if (numKeys > 0) {
            elementsBuffer.append(", " + statement + "(");
            for (int i = 0; i < numKeys; ++i) {
                String columnKey = Keys.get(i);
                if (columnKey == null) continue;
                elementsBuffer.append("\"" + columnKey + "\"");
                if (i >= numKeys - 1) continue;
                elementsBuffer.append(",");
            }
            elementsBuffer.append(")");
        }
        return elementsBuffer.toString();
    }
}

