/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class DatabaseFactory {
    public static SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc((String)configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static SessionFactory initDBConnection(String configurationFile, LexicalEngineConfiguration config) throws Exception {
        if (config == null) {
            return DatabaseFactory.initDBConnection(configurationFile);
        }
        File fl = new File(configurationFile);
        FileInputStream stream = new FileInputStream(fl);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)stream);
        List nodes = document.selectNodes("//hibernate-configuration/session-factory/property");
        for (Node currentnode : nodes) {
            String element = currentnode.valueOf("@name");
            if (element.equals("connection.driver_class")) {
                if (config.getDatabaseDriver() != null && config.getDatabaseDriver().length() > 0) {
                    currentnode.setText(config.getDatabaseDriver());
                } else {
                    config.setDatabaseDriver(currentnode.getText());
                }
            }
            if (element.equals("connection.url")) {
                if (config.getDatabaseURL() != null && config.getDatabaseURL().length() > 0) {
                    currentnode.setText(config.getDatabaseURL());
                } else {
                    config.setDatabaseURL(currentnode.getText());
                }
            }
            if (element.equals("connection.username")) {
                if (config.getDatabaseUserName() != null && config.getDatabaseUserName().length() > 0) {
                    currentnode.setText(config.getDatabaseUserName());
                } else {
                    config.setDatabaseUserName(currentnode.getText());
                }
            }
            if (element.equals("connection.password")) {
                if (config.getDatabasePassword() != null && config.getDatabasePassword().length() > 0) {
                    currentnode.setText(config.getDatabasePassword());
                } else {
                    config.setDatabasePassword(currentnode.getText());
                }
            }
            if (element.equals("dialect")) {
                if (config.getDatabaseDialect() != null && config.getDatabaseDialect().length() > 0) {
                    currentnode.setText(config.getDatabaseDialect());
                } else {
                    config.setDatabaseDialect(currentnode.getText());
                }
            }
            if (element.equals("c3p0.idleConnectionTestPeriod")) {
                if (config.getDatabaseIdleConnectionTestPeriod() != null) {
                    currentnode.setText(config.getDatabaseIdleConnectionTestPeriod());
                } else {
                    config.setDatabaseIdleConnectionTestPeriod(currentnode.getText());
                }
            }
            if (element.equals("c3p0.automaticTestTable")) {
                if (config.getDatabaseAutomaticTestTable() != null) {
                    currentnode.setText(config.getDatabaseAutomaticTestTable());
                } else {
                    config.setDatabaseAutomaticTestTable(currentnode.getText());
                }
            }
            if (!element.equals("c3p0.checkoutTimeout")) continue;
            currentnode.setText("1000");
        }
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(document.asXML().getBytes())));
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        SessionFactory DBSessionFactory = null;
        DBSessionFactory = cfg.buildSessionFactory();
        stream.close();
        return DBSessionFactory;
    }

    public static List<Object> executeSQLQuery(String query, SessionFactory DBSessionFactory) throws Exception {
        return DatabaseFactory.executeHQLQuery(query, DBSessionFactory, true);
    }

    public static List<Object> executeHQLQuery(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception, MappingException {
        Session ss = null;
        List obj = null;
        ss = DBSessionFactory.getCurrentSession();
        ss.beginTransaction();
        Object qr = null;
        qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
        List result = null;
        AnalysisLogger.getLogger().debug((Object)("In DatabaseFactory->" + qr.getQueryString()));
        try {
            result = qr.list();
            ss.getTransaction().commit();
            if (result == null) {
                System.out.println("Hibernate doesn't return a valid object when org.gcube.contentmanagement.lexicalmatcher retrieve UserState Object");
            }
            if (result != null && result.size() != 0) {
                obj = result;
            }
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            return obj;
        }
        catch (Exception e) {
            if (e.getClass().toString().contains("org.hibernate.exception.SQLGrammarException")) {
                AnalysisLogger.getLogger().debug((Object)("In DatabaseFactory-> " + e.getCause().getLocalizedMessage()));
                throw new Exception(e.getCause().getMessage());
            }
            throw e;
        }
    }

    public static void rollback(org.hibernate.Session ss) {
        try {
            if (ss != null && ss.getTransaction() != null) {
                ss.getTransaction().rollback();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                ss.close();
            }
            catch (Exception exception) {}
        }
    }
}

