/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.ITransactionalAlgorithmRepository;
import org.n52.wps.server.LocalAlgorithmRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadedAlgorithmRepository
implements ITransactionalAlgorithmRepository {
    private static Logger LOGGER = LoggerFactory.getLogger(LocalAlgorithmRepository.class);
    private Map<String, String> algorithmMap = new HashMap<String, String>();
    private Map<String, ProcessDescriptionType> processDescriptionMap = new HashMap<String, ProcessDescriptionType>();

    public UploadedAlgorithmRepository() {
        if (WPSConfig.getInstance().isRepositoryActive(this.getClass().getCanonicalName())) {
            PropertyDocument.Property[] propertyArray;
            for (PropertyDocument.Property property : propertyArray = WPSConfig.getInstance().getPropertiesForRepositoryClass(this.getClass().getCanonicalName())) {
                if (!property.getName().equalsIgnoreCase("Algorithm") || !property.getActive()) continue;
                this.addAlgorithm(property.getStringValue());
            }
        } else {
            LOGGER.debug("Local Algorithm Repository is inactive.");
        }
    }

    public boolean addAlgorithms(String[] algorithms) {
        for (String algorithmClassName : algorithms) {
            this.addAlgorithm(algorithmClassName);
        }
        LOGGER.info("Algorithms registered!");
        return true;
    }

    @Override
    public IAlgorithm getAlgorithm(String className) {
        try {
            return this.loadAlgorithm(this.algorithmMap.get(className));
        }
        catch (Exception e) {
            LOGGER.error("error getting algorithm", (Throwable)e);
            return null;
        }
    }

    public Collection<IAlgorithm> getAlgorithms() {
        ArrayList<IAlgorithm> resultList = new ArrayList<IAlgorithm>();
        try {
            for (String algorithmClasses : this.algorithmMap.values()) {
                resultList.add(this.loadAlgorithm(this.algorithmMap.get(algorithmClasses)));
            }
        }
        catch (Exception e) {
            LOGGER.error("error getting algorithm", (Throwable)e);
        }
        return resultList;
    }

    @Override
    public Collection<String> getAlgorithmNames() {
        return new ArrayList<String>(this.algorithmMap.keySet());
    }

    @Override
    public boolean containsAlgorithm(String className) {
        return this.algorithmMap.containsKey(className);
    }

    private IAlgorithm loadAlgorithm(String algorithmClassName) throws Exception {
        IAlgorithm algorithm = (IAlgorithm)LocalAlgorithmRepository.class.getClassLoader().loadClass(algorithmClassName).newInstance();
        if (!algorithm.processDescriptionIsValid()) {
            LOGGER.warn("Algorithm description is not valid: " + algorithmClassName);
            throw new Exception("Could not load algorithm " + algorithmClassName + ". ProcessDescription Not Valid.");
        }
        return algorithm;
    }

    @Override
    public boolean addAlgorithm(Object processID) {
        if (!(processID instanceof String)) {
            return false;
        }
        String algorithmClassName = (String)processID;
        this.algorithmMap.put(algorithmClassName, algorithmClassName);
        LOGGER.info("Algorithm class registered: " + algorithmClassName);
        return true;
    }

    @Override
    public boolean removeAlgorithm(Object processID) {
        if (!(processID instanceof String)) {
            return false;
        }
        String className = (String)processID;
        if (this.algorithmMap.containsKey(className)) {
            this.algorithmMap.remove(className);
            return true;
        }
        return false;
    }

    @Override
    public ProcessDescriptionType getProcessDescription(String processID) {
        if (!this.processDescriptionMap.containsKey(processID)) {
            this.processDescriptionMap.put(processID, this.getAlgorithm(processID).getDescription());
        }
        return this.processDescriptionMap.get(processID);
    }

    @Override
    public void shutdown() {
    }
}

