/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.n52.wps.algorithm.descriptor.Descriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;

public class AlgorithmDescriptor
extends Descriptor {
    private final String version;
    private final boolean storeSupported;
    private final boolean statusSupported;
    private final Map<String, InputDescriptor> inputDescriptorMap;
    private final Map<String, OutputDescriptor> outputDescriptorMap;

    AlgorithmDescriptor(Builder<? extends Builder<?>> builder) {
        super(builder);
        this.version = ((Builder)builder).version;
        this.storeSupported = ((Builder)builder).storeSupported;
        this.statusSupported = ((Builder)builder).statusSupported;
        Preconditions.checkState((((Builder)builder).outputDescriptors.size() > 0 ? 1 : 0) != 0, (Object)"Need at minimum 1 output for algorithm.");
        LinkedHashMap<String, InputDescriptor> iMap = new LinkedHashMap<String, InputDescriptor>();
        for (InputDescriptor iDescriptor : ((Builder)builder).inputDescriptors) {
            iMap.put(iDescriptor.getIdentifier(), iDescriptor);
        }
        this.inputDescriptorMap = Collections.unmodifiableMap(iMap);
        LinkedHashMap<String, OutputDescriptor> oMap = new LinkedHashMap<String, OutputDescriptor>();
        for (OutputDescriptor oDescriptor : ((Builder)builder).outputDescriptors) {
            oMap.put(oDescriptor.getIdentifier(), oDescriptor);
        }
        this.outputDescriptorMap = Collections.unmodifiableMap(oMap);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getStoreSupported() {
        return this.storeSupported;
    }

    public boolean getStatusSupported() {
        return this.statusSupported;
    }

    public List<String> getInputIdentifiers() {
        return Collections.unmodifiableList(new ArrayList<String>(this.inputDescriptorMap.keySet()));
    }

    public InputDescriptor getInputDescriptor(String identifier) {
        return this.inputDescriptorMap.get(identifier);
    }

    public Collection<InputDescriptor> getInputDescriptors() {
        return this.inputDescriptorMap.values();
    }

    public List<String> getOutputIdentifiers() {
        return Collections.unmodifiableList(new ArrayList<String>(this.outputDescriptorMap.keySet()));
    }

    public OutputDescriptor getOutputDescriptor(String identifier) {
        return this.outputDescriptorMap.get(identifier);
    }

    public Collection<OutputDescriptor> getOutputDescriptors() {
        return this.outputDescriptorMap.values();
    }

    public static Builder<?> builder(String identifier) {
        return new BuilderTyped(identifier);
    }

    public static Builder<?> builder(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz may not be null");
        return new BuilderTyped(clazz.getCanonicalName());
    }

    public static abstract class Builder<B extends Builder<B>>
    extends Descriptor.Builder<B> {
        private String version = "1.0.0";
        private boolean storeSupported = true;
        private boolean statusSupported = true;
        private List<InputDescriptor> inputDescriptors;
        private List<OutputDescriptor> outputDescriptors;

        protected Builder(String identifier) {
            super(identifier);
            this.title(identifier);
            this.inputDescriptors = new ArrayList<InputDescriptor>();
            this.outputDescriptors = new ArrayList<OutputDescriptor>();
        }

        public B version(String version) {
            this.version = version;
            return (B)((Builder)this.self());
        }

        public B storeSupported(boolean storeSupported) {
            this.storeSupported = storeSupported;
            return (B)((Builder)this.self());
        }

        public B statusSupported(boolean statusSupported) {
            this.statusSupported = statusSupported;
            return (B)((Builder)this.self());
        }

        public B addInputDescriptor(InputDescriptor.Builder inputDescriptorBuilder) {
            return this.addInputDescriptor(inputDescriptorBuilder.build());
        }

        public B addInputDescriptor(InputDescriptor inputDescriptor) {
            this.inputDescriptors.add(inputDescriptor);
            return (B)((Builder)this.self());
        }

        public B addInputDescriptors(List<? extends InputDescriptor> inputDescriptors) {
            this.inputDescriptors.addAll(inputDescriptors);
            return (B)((Builder)this.self());
        }

        public B addOutputDescriptor(OutputDescriptor.Builder outputDescriptorBuilder) {
            return this.addOutputDescriptor(outputDescriptorBuilder.build());
        }

        public B addOutputDescriptor(OutputDescriptor outputDescriptor) {
            this.outputDescriptors.add(outputDescriptor);
            return (B)((Builder)this.self());
        }

        public B addOutputDescriptors(List<? extends OutputDescriptor> outputDescriptors) {
            this.outputDescriptors.addAll(outputDescriptors);
            return (B)((Builder)this.self());
        }

        public AlgorithmDescriptor build() {
            return new AlgorithmDescriptor(this);
        }
    }

    private static class BuilderTyped
    extends Builder<BuilderTyped> {
        public BuilderTyped(String identifier) {
            super(identifier);
        }

        @Override
        protected BuilderTyped self() {
            return this;
        }
    }
}

