/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.n52.wps.GeneratorDocument;
import org.n52.wps.ParserDocument;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.server.CapabilitiesConfiguration;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.handler.RequestHandler;
import org.n52.wps.util.XMLBeansHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebProcessingService
extends HttpServlet {
    private static final long serialVersionUID = 8943233273641771839L;
    public static String PROPERTY_NAME_WEBAPP_PATH = "webappPath";
    public static String BASE_DIR = null;
    public static String WEBAPP_PATH = null;
    public static String SERVLET_PATH = "WebProcessingService";
    public static String WPS_NAMESPACE = "http://www.opengis.net/wps/1.0.0";
    public static String DEFAULT_LANGUAGE = "en-US";
    protected static Logger LOGGER = LoggerFactory.getLogger(WebProcessingService.class);
    public static final String PROP_forceGeoToolsXYAxisOrder = "forceGeoToolsXYAxisOrder";
    public static final int MAXIMUM_REQUEST_SIZE = 0x8000000;
    public static final String SPECIAL_XML_POST_VARIABLE = "request";
    private static final String XML_CONTENT_TYPE = "text/xml";

    private static OutputStream getConfiguredOutputStream(HttpServletRequest hsRequest, HttpServletResponse hsResponse) throws IOException {
        hsResponse.setHeader("Expires", "0");
        if (hsRequest.getProtocol().equals("HTTP/1.1")) {
            hsResponse.setHeader("Cache-Control", "no-cache");
        } else if (hsRequest.getProtocol().equals("HTTP/1.0")) {
            hsResponse.setHeader("Pragma", "no-cache");
        }
        if (hsRequest.getHeader("Accept-Encoding") != null && hsRequest.getHeader("Accept-Encoding").indexOf("gzip") >= 0) {
            hsResponse.setHeader("Content-Encoding", "gzip");
            LOGGER.info("gzip-Compression for output enabled");
            return new GZIPOutputStream((OutputStream)hsResponse.getOutputStream());
        }
        LOGGER.info("gzip-Compression for output disabled");
        return hsResponse.getOutputStream();
    }

    public void init(ServletConfig config) throws ServletException {
        PropertyDocument.Property[] serverProps;
        super.init(config);
        LOGGER.info("WebProcessingService initializing...");
        try {
            if (WPSConfig.getInstance((ServletConfig)config) == null) {
                LOGGER.error("Initialization failed! Please look at the properties file!");
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Initialization failed! Please look at the properties file!", (Throwable)e);
            return;
        }
        LOGGER.info("Initialization of wps properties successful!");
        for (PropertyDocument.Property property : serverProps = WPSConfig.getInstance().getPropertiesForServer()) {
            if (!PROP_forceGeoToolsXYAxisOrder.equals(property.getName())) continue;
            if (!Boolean.parseBoolean(property.getStringValue())) break;
            System.setProperty("org.geotools.referencing.forceXY", "true");
            LOGGER.info("Set org.geotools.referencing.forceXY to true.");
            break;
        }
        BASE_DIR = this.getServletContext().getRealPath("");
        ParserDocument.Parser[] parsers = WPSConfig.getInstance().getActiveRegisteredParser();
        ParserFactory.initialize((ParserDocument.Parser[])parsers);
        GeneratorDocument.Generator[] generators = WPSConfig.getInstance().getActiveRegisteredGenerator();
        GeneratorFactory.initialize((GeneratorDocument.Generator[])generators);
        RepositoryManager.getInstance();
        LOGGER.info("Algorithms initialized");
        String customWebappPath = WPSConfig.getInstance().getWPSConfig().getServer().getWebappPath();
        if (customWebappPath != null) {
            WEBAPP_PATH = customWebappPath;
        } else {
            WEBAPP_PATH = "wps";
            LOGGER.warn("No custom webapp path found, use default wps");
        }
        LOGGER.info("webappPath is set to: " + customWebappPath);
        try {
            CapabilitiesConfiguration.getInstance(BASE_DIR + File.separator + "config" + File.separator + "wpsCapabilitiesSkeleton.xml");
        }
        catch (IOException e) {
            LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
        }
        catch (XmlException e) {
            LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
        }
        DatabaseFactory.getDatabase();
        LOGGER.info("WPS up and running!");
        WPSConfig.getInstance().addPropertyChangeListener("WPSCapabilitiesUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LOGGER.info(this.getClass().getName() + ": Received Property Change Event: " + propertyChangeEvent.getPropertyName());
                try {
                    CapabilitiesConfiguration.reloadSkeleton();
                }
                catch (IOException e) {
                    LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
                }
                catch (XmlException e) {
                    LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
                }
            }
        });
        WPSConfig.getInstance().addPropertyChangeListener("WPSConfigUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LOGGER.info(this.getClass().getName() + ": Received Property Change Event: " + propertyChangeEvent.getPropertyName());
                try {
                    CapabilitiesConfiguration.reloadSkeleton();
                }
                catch (IOException e) {
                    LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
                }
                catch (XmlException e) {
                    LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            ServletOutputStream out = res.getOutputStream();
            RequestHandler handler = new RequestHandler(req.getParameterMap(), (OutputStream)out);
            String mimeType = handler.getResponseMimeType();
            res.setContentType(mimeType);
            handler.handle();
            res.setStatus(200);
        }
        catch (ExceptionReport e) {
            WebProcessingService.handleException(e, res);
        }
        catch (RuntimeException e) {
            ExceptionReport er = new ExceptionReport("Error handing request: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
            WebProcessingService.handleException(er, res);
        }
        finally {
            if (res != null) {
                res.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        BufferedReader reader = null;
        try {
            int requestSize;
            int read;
            int contentLength;
            String contentType = req.getContentType();
            String characterEncoding = req.getCharacterEncoding();
            if (characterEncoding == null || characterEncoding.length() == 0) {
                characterEncoding = "UTF-8";
            }
            if ((contentLength = req.getContentLength()) > 0x8000000) {
                LOGGER.warn("POST request rejected, request size of " + contentLength + " too large.");
                ExceptionReport er = new ExceptionReport("Request body too large, limited to 134217728 bytes", "NoApplicableCode");
                WebProcessingService.handleException(er, res);
            }
            LOGGER.debug("Received POST: Content-Type = " + contentType + ", Character-Encoding = " + characterEncoding + ", Content-Length = " + contentLength);
            StringWriter writer = contentLength > 0 ? new StringWriter(contentLength) : new StringWriter();
            reader = req.getReader();
            char[] buffer = new char[8192];
            for (requestSize = 0; (read = reader.read(buffer)) != -1 && requestSize < 0x8000000; requestSize += read) {
                writer.write(buffer, 0, read);
            }
            LOGGER.debug("POST request contained  " + requestSize + " characters");
            if (requestSize >= 0x8000000 && reader.read() > -1) {
                LOGGER.warn("POST request rejected, request size of " + requestSize + " too large.");
                ExceptionReport er = new ExceptionReport("Request body too large, limited to 134217728 bytes", "NoApplicableCode");
                WebProcessingService.handleException(er, res);
            }
            String documentString = writer.toString();
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                if (documentString.startsWith("request=")) {
                    documentString = documentString.substring(SPECIAL_XML_POST_VARIABLE.length() + 1);
                    LOGGER.debug("POST request form variable removed");
                }
                documentString = URLDecoder.decode(documentString, characterEncoding);
                LOGGER.debug("Decoded of POST:\n" + documentString + "\n");
            }
            RequestHandler handler = new RequestHandler(new ByteArrayInputStream(documentString.getBytes("UTF-8")), (OutputStream)res.getOutputStream());
            String mimeType = handler.getResponseMimeType();
            res.setContentType(mimeType);
            handler.handle();
            res.setStatus(200);
        }
        catch (ExceptionReport e) {
            WebProcessingService.handleException(e, res);
        }
        catch (Exception e) {
            ExceptionReport er = new ExceptionReport("Error handing request: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
            WebProcessingService.handleException(er, res);
        }
        finally {
            if (res != null) {
                res.flushBuffer();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (SERVLET_PATH == null) {
            req.getContextPath();
        }
        super.service(req, res);
    }

    private static void handleException(ExceptionReport exception, HttpServletResponse res) {
        res.setContentType(XML_CONTENT_TYPE);
        try {
            LOGGER.debug(exception.toString());
            exception.getExceptionDocument().save((OutputStream)res.getOutputStream(), XMLBeansHelper.getXmlOptions());
            res.setStatus(exception.getHTTPStatusCode());
        }
        catch (IOException e) {
            LOGGER.warn("exception occured while writing ExceptionReport to stream");
            try {
                res.sendError(500, "error occured, while writing OWS Exception output");
            }
            catch (IOException ex) {
                LOGGER.error("error while writing error code to client!");
                res.setStatus(500);
            }
        }
    }

    public void destroy() {
        super.destroy();
        DatabaseFactory.getDatabase().shutdown();
    }
}

