/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request;

import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.WebProcessingService;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.response.DescribeProcessResponse;
import org.n52.wps.server.response.Response;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeProcessRequest
extends Request {
    private ProcessDescriptionsDocument document;

    public DescribeProcessRequest(CaseInsensitiveMap ciMap) throws ExceptionReport {
        super(ciMap);
    }

    public DescribeProcessRequest(Document doc) throws ExceptionReport {
        super(doc);
        NamedNodeMap nnm = doc.getFirstChild().getAttributes();
        this.map = new CaseInsensitiveMap();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            if (n.getLocalName().equalsIgnoreCase("service")) {
                this.map.put((Object)n.getLocalName(), (Object)new String[]{n.getNodeValue()});
                continue;
            }
            if (!n.getLocalName().equalsIgnoreCase("version")) continue;
            this.map.put((Object)n.getLocalName(), (Object)new String[]{n.getNodeValue()});
        }
        String identifierList = "";
        NodeList nList = doc.getFirstChild().getChildNodes();
        boolean identifierParameterExists = false;
        for (int i = 0; i < nList.getLength(); ++i) {
            Node n = nList.item(i);
            if (n.getLocalName() == null || !n.getLocalName().equalsIgnoreCase("identifier")) continue;
            identifierParameterExists = true;
            String s = n.getTextContent();
            if (s == null || s.isEmpty()) continue;
            identifierList = identifierList.concat(s + ",");
        }
        if (identifierParameterExists) {
            this.map.put((Object)"identifier", (Object)new String[]{identifierList});
        }
    }

    @Override
    public boolean validate() throws ExceptionReport {
        this.getMapValue("version", true, new String[]{"1.0.0"});
        this.getMapValue("identifier", true);
        return true;
    }

    @Override
    public Object getAttachedResult() {
        return this.document;
    }

    @Override
    public Response call() throws ExceptionReport {
        this.validate();
        this.document = ProcessDescriptionsDocument.Factory.newInstance();
        this.document.addNewProcessDescriptions();
        XmlCursor c = this.document.newCursor();
        c.toFirstChild();
        c.toLastAttribute();
        c.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), "http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsDescribeProcess_response.xsd");
        String[] identifiers = this.getMapValue("identifier", true).split(",");
        this.document.getProcessDescriptions().setLang(WebProcessingService.DEFAULT_LANGUAGE);
        this.document.getProcessDescriptions().setService("WPS");
        this.document.getProcessDescriptions().setVersion("1.0.0");
        if (identifiers.length == 1 && identifiers[0].equalsIgnoreCase("all")) {
            List<String> identifierList = RepositoryManager.getInstance().getAlgorithms();
            identifiers = new String[identifierList.size()];
            for (int i = 0; i < identifierList.size(); ++i) {
                identifiers[i] = identifierList.get(i);
            }
        }
        if (identifiers.length == 1 && (identifiers[0] == null || identifiers[0].isEmpty())) {
            throw new ExceptionReport("Process description request with empty identifier.", "InvalidParameterValue", "identifier");
        }
        for (String algorithmName : identifiers) {
            if (!RepositoryManager.getInstance().containsAlgorithm(algorithmName)) {
                throw new ExceptionReport("Algorithm does not exist: " + algorithmName, "InvalidParameterValue", "identifier");
            }
            ProcessDescriptionType description = RepositoryManager.getInstance().getProcessDescription(algorithmName);
            this.document.getProcessDescriptions().addNewProcessDescription().set((XmlObject)description);
        }
        LOGGER.info("Handled Request successfully for: " + this.getMapValue("identifier", true));
        return new DescribeProcessResponse(this);
    }
}

