/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.response;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.response.ResponseData;

public class RawData
extends ResponseData {
    public static final Joiner SPACE_JOINER = Joiner.on((String)" ");

    public RawData(IData obj, String id, String schema, String encoding, String mimeType, String algorithmIdentifier, ProcessDescriptionType description) throws ExceptionReport {
        super(obj, id, schema, encoding, mimeType, algorithmIdentifier, description);
        if (obj instanceof IComplexData) {
            this.prepareGenerator();
        }
    }

    public InputStream getAsStream() throws ExceptionReport {
        try {
            if (this.obj instanceof ILiteralData) {
                return new ByteArrayInputStream(String.valueOf(this.obj.getPayload()).getBytes(Charsets.UTF_8));
            }
            if (this.obj instanceof IBBOXData) {
                IBBOXData bbox = (IBBOXData)this.obj;
                StringBuilder builder = new StringBuilder();
                builder.append("<wps:BoundingBoxData");
                this.appendAttr(builder, "xmlns:ows", "http://www.opengis.net/ows/1.1");
                this.appendAttr(builder, "xmlns:wps", "http://www.opengis.net/wps/1.0.0");
                if (bbox.getCRS() != null) {
                    this.appendAttr(builder, "crs", RawData.escape(bbox.getCRS()));
                }
                this.appendAttr(builder, "dimensions", bbox.getDimension());
                builder.append(">");
                builder.append("\n\t");
                builder.append("<ows:LowerCorner>");
                SPACE_JOINER.appendTo(builder, (Iterable)Doubles.asList((double[])bbox.getLowerCorner()));
                builder.append("</ows:LowerCorner>");
                builder.append("\n\t");
                builder.append("<ows:UpperCorner>");
                SPACE_JOINER.appendTo(builder, (Iterable)Doubles.asList((double[])bbox.getUpperCorner()));
                builder.append("</ows:UpperCorner>");
                builder.append("\n");
                builder.append("</wps:BoundingBoxData>");
                return new ByteArrayInputStream(builder.toString().getBytes(Charsets.UTF_8));
            }
            if (this.encoding == null || "".equals(this.encoding) || this.encoding.equalsIgnoreCase("UTF-8")) {
                return this.generator.generateStream(this.obj, this.mimeType, this.schema);
            }
            if (this.encoding.equalsIgnoreCase("base64")) {
                return this.generator.generateBase64Stream(this.obj, this.mimeType, this.schema);
            }
        }
        catch (IOException e) {
            throw new ExceptionReport("Error while generating Complex Data out of the process result", "NoApplicableCode", (Throwable)e);
        }
        throw new ExceptionReport("Could not determine encoding. Use default (=not set) or base64", "NoApplicableCode");
    }

    private StringBuilder appendAttr(StringBuilder builder, String key, Object value) {
        return builder.append(' ').append(key).append('=').append('\"').append(value).append('\"');
    }

    private static String escape(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

