package org.gcube.dataanalysis.executor.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State.Done;
import org.gcube.common.core.utils.handlers.lifetime.State.Failed;
import org.gcube.common.core.utils.handlers.lifetime.State.Running;
import org.gcube.dataanalysis.executor.scripts.GetExecuteScript;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class ExecutorScriptPlugin extends GCUBEHandler<TaskRuntime> implements ExecutorTask {

	@Override
	public void stop() throws UnsupportedOperationException, Exception {
		this.getLogger().trace("ExecuteScript Plugin: Stopped");
	}

	static int locked;

	@Override
	public void run() throws Exception {
		this.setState(Running.INSTANCE);
		this.getLogger().trace("ExecuteScript: Start");
		TaskRuntime runtime = this.getHandled();
		// Thread.sleep(2000);
		GetExecuteScript scripter = new GetExecuteScript(this.getLogger());
		if (locked > 0) {
			this.getLogger().trace("ExecuteScript: LOCKED!");
			this.setState(Done.INSTANCE);
		} else {
			locked = 1;
			Map<String, Object> inputs = runtime.getInputs();
			this.getLogger().trace("ExecuteScript Inputs: " + inputs);
			try {
				Object[] filesnamesObj = (Object[]) inputs.get("FILE_NAMES");
				List<String> filenames = new ArrayList<String>();
				int filenamesL = filesnamesObj.length;
				for (int i = 0; i < filenamesL; i++) {
					filenames.add((String) filesnamesObj[i]);
				}

				Object[] fileurlsObj = (Object[]) inputs.get("FILE_URLS");
				List<String> fileurls = new ArrayList<String>();
				int fileurlsL = fileurlsObj.length;
				for (int i = 0; i < fileurlsL; i++) {
					fileurls.add((String) fileurlsObj[i]);
				}

				String outputDir = ScriptIOWorker.getString((String) inputs.get("OUTPUTDIR"));
				String script = ScriptIOWorker.getString((String) inputs.get("SCRIPT"));
				String arguments = ScriptIOWorker.getString((String) inputs.get("ARGUMENTS"));
				String identifier = ScriptIOWorker.getString((String) inputs.get("NODE_IDENTIFIER"));
				String scope = ScriptIOWorker.getString((String) inputs.get("SCOPE"));
				String serviceClass = ScriptIOWorker.getString((String) inputs.get("SERVICE_CLASS"));
				String serviceName = ScriptIOWorker.getString((String) inputs.get("SERVICE_NAME"));
				String owner = ScriptIOWorker.getString((String) inputs.get("OWNER"));
				String remoteDir = ScriptIOWorker.getString((String) inputs.get("REMOTEDIR"));
				String session = ScriptIOWorker.getString((String) inputs.get("SESSION"));
				String delFiles = ScriptIOWorker.getString((String) inputs.get("CLEAN_CACHE"));
				boolean deletefiles = delFiles==null? true : Boolean.parseBoolean(delFiles);
				
				// showDefaultElements();
				// showElements(scope, serviceClass, serviceName, owner, remoteDir, true);
				// showElements(scope, serviceClass, serviceName, owner, remoteDir, false);
				scripter.executeScript(filenames, fileurls, outputDir, script, arguments, identifier, scope, serviceClass, serviceName, owner, remoteDir,session,deletefiles);

				this.getLogger().trace("ExecuteScript: End");
				stop();
				this.getLogger().trace("ExecuteScript: Completely Finished");
				this.setState(Done.INSTANCE);
				locked =0;
			} catch (Exception e) {
				e.printStackTrace();
				this.getLogger().error("ExecuteScript: Error " + e.getLocalizedMessage());
				this.getLogger().trace("ExecuteScript: End");
				stop();
				this.getLogger().trace("ExecuteScript: Completely Finished");
				this.setState(Failed.INSTANCE);
				locked =0;
			}
		}

	}

}
