/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.user.GeneratorT;
import org.gcube.dataanalysis.executor.generators.v1.D4ScienceQueueGenerator;
import org.gcube.dataanalysis.executor.tests.TestGenerator;

public class TestD4ScienceQueueMaps {
    public static void main(String[] args) throws Exception {
        int k1 = 0;
        int k2 = 3;
        for (int i = k1; i < k2; ++i) {
            TestD4ScienceQueueMaps testD4ScienceQueueMaps = new TestD4ScienceQueueMaps();
            testD4ScienceQueueMaps.getClass();
            ThreadGenerator tg = testD4ScienceQueueMaps.new ThreadGenerator("hspec_suitable_executor_chunkizedall" + (i + 1));
            Thread t = new Thread(tg);
            t.start();
            Thread.sleep(2000L);
        }
    }

    public static void produce(String output) throws Exception {
        String configPath = "./cfg/";
        String csquareTable = "hcaf_d";
        String preprocessedTable = "maxminlat_hspen";
        String envelopeTable = "hspen";
        int numberOfResources = 1;
        String userName = "gianpaolo.coro";
        String generatorName = "AQUAMAPS_SUITABLE";
        String scope = "/gcube";
        String finalDistributionTable = output;
        AlgorithmConfiguration config = GeneratorT.getGenerationConfig((int)numberOfResources, (String)generatorName, (String)envelopeTable, (String)preprocessedTable, (String)"", (String)userName, (String)csquareTable, (String)finalDistributionTable, (String)configPath);
        config.setPersistencePath("./");
        config.setGcubeScope(scope);
        config.setParam("ServiceUserName", "gianpaolo.coro");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated");
        config.setParam("DatabaseDriver", "org.hibernate.dialect.PostgreSQLDialect");
        config.setTableSpace("tbsp_1");
        TestD4ScienceQueueMaps.generate(config);
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        D4ScienceQueueGenerator generator = new D4ScienceQueueGenerator(config);
        generator.init();
        if (generator != null) {
            long t0 = System.currentTimeMillis();
            TestGenerator tgs = new TestGenerator((ComputationalAgent)generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(10000L);
            }
            System.out.println("FINAL STATUS: " + generator.getStatus() + " ELAPSED " + (System.currentTimeMillis() - t0));
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
    }

    public class ThreadGenerator
    implements Runnable {
        String table;

        public ThreadGenerator(String table) {
            this.table = table;
        }

        @Override
        public void run() {
            try {
                TestD4ScienceQueueMaps.produce(this.table);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

