/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.user.GeneratorT;
import org.gcube.dataanalysis.executor.generators.v1.D4ScienceQueueGenerator;
import org.gcube.dataanalysis.executor.tests.TestGenerator;

public class TestD4ScienceQueueMaps3 {
    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String csquareTable = "hcaf_d";
        String preprocessedTable = "maxminlat_hspen";
        String envelopeTable = "hspen";
        int numberOfResources = 1;
        String userName = "gianpaolo.coro";
        String generatorName = "AQUAMAPS_SUITABLE";
        String scope = "/gcube";
        String finalDistributionTable = "hspec_suitable_executor_1";
        AlgorithmConfiguration config = GeneratorT.getGenerationConfig((int)numberOfResources, (String)generatorName, (String)envelopeTable, (String)preprocessedTable, (String)"", (String)userName, (String)csquareTable, (String)finalDistributionTable, (String)configPath);
        config.setPersistencePath("./");
        config.setGcubeScope(scope);
        config.setParam("ServiceUserName", "gianpaolo.coro");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated");
        config.setParam("DatabaseDriver", "org.hibernate.dialect.PostgreSQLDialect");
        config.setTableSpace("tbsp_1");
        TestD4ScienceQueueMaps3.generate(config);
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        D4ScienceQueueGenerator generator = new D4ScienceQueueGenerator(config);
        generator.init();
        if (generator != null) {
            long t0 = System.currentTimeMillis();
            TestGenerator tgs = new TestGenerator((ComputationalAgent)generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(10000L);
            }
            System.out.println("FINAL STATUS: " + generator.getStatus() + " ELAPSED " + (System.currentTimeMillis() - t0));
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
    }
}

