/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.generators.v1;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionNode;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.job.management.QueueJobManager;

public class D4ScienceQueueGenerator
implements Generator {
    protected AlgorithmConfiguration config;
    protected SpatialProbabilityDistributionNode distributionModel;
    protected QueueJobManager jobManager;
    protected static String defaultJobOutput = "execution.output";
    protected static String defaultScriptFile = "script.sh";
    public static boolean deletefiles = true;
    protected String mainclass;
    protected boolean stop;
    protected static int maxSpeciesAllowedPerJob = 20;
    public static boolean forceUpload = true;
    protected int speciesBlocksExecuted;
    protected int speciesBlocks;
    private long lastTime;
    private int lastProcessed;

    public D4ScienceQueueGenerator() {
        this.stop = false;
    }

    public D4ScienceQueueGenerator(AlgorithmConfiguration config) {
        this.config = config;
        this.stop = false;
        AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
    }

    public void compute() throws Exception {
        block13: {
            try {
                String scope = this.config.getGcubeScope();
                if (scope == null) {
                    throw new Exception("Null Scope");
                }
                int speciesNum = this.distributionModel.getNumberOfSpecies();
                int geoNum = this.distributionModel.getNumberOfGeoInfo();
                List endpoints = this.config.getEndpoints();
                if (endpoints != null) {
                    ArrayList<EndpointReferenceType> eprtList = new ArrayList<EndpointReferenceType>();
                    for (String ep : endpoints) {
                        eprtList.add(new EndpointReferenceType(new Address(ep)));
                    }
                    this.jobManager = new QueueJobManager(scope, this.config.getNumberOfResources(), eprtList);
                } else {
                    this.jobManager = new QueueJobManager(scope, this.config.getNumberOfResources());
                }
                int numberOfResources = this.jobManager.getNumberOfNodes();
                if (numberOfResources > 0) {
                    int div = speciesNum / (numberOfResources * maxSpeciesAllowedPerJob);
                    int rest = speciesNum % (numberOfResources * maxSpeciesAllowedPerJob);
                    if (rest > 0) {
                        ++div;
                    }
                    if (div == 0) {
                        div = 1;
                    }
                    this.executeWork(geoNum, speciesNum, 0, div, deletefiles, forceUpload);
                    if (this.jobManager.wasAborted()) {
                        AnalysisLogger.getLogger().debug((Object)"Warning: Job was aborted");
                        this.distributionModel.postProcess(false, true);
                        throw new Exception("Job System Error");
                    }
                    this.distributionModel.postProcess(this.jobManager.hasResentMessages(), false);
                    break block13;
                }
                AnalysisLogger.getLogger().debug((Object)"Warning: No Workers available");
                throw new Exception("No Workers available");
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().error((Object)"ERROR: An Error occurred ", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
            finally {
                this.speciesBlocksExecuted = this.speciesBlocks;
                this.shutdown();
            }
        }
    }

    private void executeWork(int geoNum, int speciesNum, int speciesOffset, int numberOfResources, boolean deletefiles, boolean forceUpload) throws Exception {
        int[] chunkSizes = Operations.takeChunks((int)speciesNum, (int)numberOfResources);
        ArrayList<String> arguments = new ArrayList<String>();
        int order = speciesOffset;
        for (int i = 0; i < chunkSizes.length; ++i) {
            String argumentString = "0 " + geoNum + " " + order + " " + chunkSizes[i] + " ./ " + this.mainclass;
            arguments.add(argumentString);
            order += chunkSizes[i];
            AnalysisLogger.getLogger().debug((Object)("D4ScienceGenerator-> Argument " + i + ": " + argumentString));
        }
        String owner = this.config.getParam("ServiceUserName");
        if (owner == null) {
            throw new Exception("Null Owner");
        }
        String pathToDir = this.config.getPersistencePath() + this.config.getModel();
        if (!new File(pathToDir).exists()) {
            throw new Exception("No Implementation of node-model found for algorithm " + pathToDir);
        }
        if (this.mainclass == null) {
            throw new Exception("No mainClass found for algorithm " + pathToDir);
        }
        this.buildScriptFile(this.config.getModel(), defaultJobOutput, pathToDir, this.mainclass);
        this.jobManager.uploadAndExecuteChunkized(AlgorithmConfiguration.StatisticalManagerClass, AlgorithmConfiguration.StatisticalManagerService, owner, pathToDir, "/" + this.config.getModel() + "/", "./", defaultScriptFile, arguments, new XStream().toXML((Object)this.config), deletefiles, forceUpload);
    }

    public void buildScriptFile(String jobName, String jobOutput, String jarsPath, String fullMainClass) throws Exception {
        File expectedscript = new File(jarsPath, defaultScriptFile);
        if (!expectedscript.exists()) {
            File[] files;
            StringBuffer sb = new StringBuffer();
            sb.append("#!/bin/sh\n");
            sb.append("# " + jobName + "\n");
            sb.append("cd $1\n");
            sb.append("\n");
            sb.append("java -Xmx1024M -classpath ./:");
            File jarsPathF = new File(jarsPath);
            for (File jar : files = jarsPathF.listFiles()) {
                if (!jar.getName().endsWith(".jar")) continue;
                sb.append("./" + jar.getName());
                sb.append(":");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" " + fullMainClass + " $2 " + jobOutput);
            sb.append("\n");
            AnalysisLogger.getLogger().trace((Object)("D4ScienceGenerator->Generating script in " + expectedscript.getAbsolutePath()));
            FileTools.saveString((String)expectedscript.getAbsolutePath(), (String)sb.toString(), (boolean)true, (String)"UTF-8");
        }
        AnalysisLogger.getLogger().trace((Object)("D4ScienceGenerator->Script " + expectedscript.getAbsolutePath() + " yet exists!"));
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> distributionModelParams = new ArrayList<StatisticalType>();
        distributionModelParams.add((StatisticalType)new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
        return distributionModelParams;
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            int activeNodes = this.jobManager.getActiveNodes();
            for (int i = 0; i < activeNodes; ++i) {
                try {
                    res.addResource("Worker_" + (i + 1), 100.0);
                    continue;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"D4ScienceGnerator->active nodes not ready");
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon((Object)res.list).replace("resId", "resID");
        }
        return "";
    }

    public float getStatus() {
        try {
            if (this.stop) {
                return 100.0f;
            }
            return Math.max(0.5f, this.jobManager.getStatus() * 100.0f);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public StatisticalType getOutput() {
        return this.distributionModel.getOutput();
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PARALLEL_SPECIES_VS_CSQUARE_FROM_DATABASE};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }

    public void init() throws Exception {
        Properties p = AlgorithmConfiguration.getProperties((String)(this.config.getConfigPath() + AlgorithmConfiguration.nodeAlgorithmsFile));
        this.mainclass = p.getProperty(this.config.getModel());
        this.distributionModel = (SpatialProbabilityDistributionNode)Class.forName(this.mainclass).newInstance();
        this.distributionModel.setup(this.config);
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
        AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
    }

    public void shutdown() {
        try {
            this.jobManager.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.distributionModel.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop = true;
    }

    public String getLoad() {
        long tk = System.currentTimeMillis();
        int processedSpecies = this.distributionModel.getNumberOfProcessedSpecies();
        ResourceLoad rs = new ResourceLoad(tk, (double)processedSpecies);
        return rs.toString();
    }

    public String getResourceLoad() {
        long thisTime = System.currentTimeMillis();
        int processedRecords = this.distributionModel.getNumberOfProcessedSpecies();
        int estimatedProcessedRecords = 0;
        estimatedProcessedRecords = processedRecords == this.lastProcessed ? Math.round((float)thisTime * (float)this.lastProcessed / (float)this.lastTime) : (this.lastProcessed = processedRecords);
        this.lastTime = thisTime;
        ResourceLoad rs = new ResourceLoad(thisTime, (double)estimatedProcessedRecords);
        return rs.toString();
    }

    public GenericAlgorithm getAlgorithm() {
        return this.distributionModel;
    }

    public String getDescription() {
        return "A D4Science Cloud Processor for Species Distributions";
    }
}

