/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.generators.v1;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionNode;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.job.management.RemoteJobManager;

public class D4ScienceGenerator
implements Generator {
    protected AlgorithmConfiguration config;
    protected SpatialProbabilityDistributionNode distributionModel;
    protected RemoteJobManager jobManager;
    protected static String defaultJobOutput = "execution.output";
    protected static String defaultScriptFile = "script.sh";
    protected String mainclass;
    protected boolean stop;
    protected static int maxSpeciesAllowedPerJob = 10;
    protected int speciesBlocksExecuted;
    protected int speciesBlocks;
    private long lastTime;
    private int lastProcessed;

    public D4ScienceGenerator() {
        this.stop = false;
    }

    public D4ScienceGenerator(AlgorithmConfiguration config) {
        this.config = config;
        this.stop = false;
        AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
    }

    public void compute() throws Exception {
        block13: {
            try {
                String scope = this.config.getGcubeScope();
                if (scope == null) {
                    throw new Exception("Null Scope");
                }
                int speciesNum = this.distributionModel.getNumberOfSpecies();
                int geoNum = this.distributionModel.getNumberOfGeoInfo();
                List endpoints = this.config.getEndpoints();
                if (endpoints != null) {
                    ArrayList<EndpointReferenceType> eprtList = new ArrayList<EndpointReferenceType>();
                    for (String ep : endpoints) {
                        eprtList.add(new EndpointReferenceType(new Address(ep)));
                    }
                    this.jobManager = new RemoteJobManager(scope, this.config.getNumberOfResources(), eprtList);
                } else {
                    this.jobManager = new RemoteJobManager(scope, this.config.getNumberOfResources());
                }
                int numberOfResources = this.jobManager.getNumberOfNodes();
                if (numberOfResources <= 0) break block13;
                int div = speciesNum / (numberOfResources * maxSpeciesAllowedPerJob);
                int rest = speciesNum % (numberOfResources * maxSpeciesAllowedPerJob);
                if (rest > 0) {
                    ++div;
                }
                if (div == 0) {
                    div = 1;
                }
                int[] speciesChunks = Operations.takeChunks((int)speciesNum, (int)div);
                this.speciesBlocks = speciesChunks.length;
                int offset = 0;
                boolean deletefiles = true;
                for (int i = 0; i < this.speciesBlocks; ++i) {
                    AnalysisLogger.getLogger().debug((Object)("D4ScienceGenerator-> EXECUTING THE BUNCH OF " + speciesChunks[i] + " SPECIES - NUMBER " + (i + 1) + " OF " + this.speciesBlocks + " WITH OFFSET " + offset));
                    if (i == this.speciesBlocks - 1) {
                        deletefiles = true;
                    }
                    this.executeWork(geoNum, speciesChunks[i], offset, numberOfResources, deletefiles);
                    offset += speciesChunks[i];
                    ++this.speciesBlocksExecuted;
                    if (!this.jobManager.wasAborted()) continue;
                    AnalysisLogger.getLogger().debug((Object)"Warning: Job was aborted");
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                this.speciesBlocksExecuted = this.speciesBlocks;
                this.shutdown();
            }
        }
    }

    private void executeWork(int geoNum, int speciesNum, int speciesOffset, int numberOfResources, boolean deletefiles) throws Exception {
        int[] chunkSizes = Operations.takeChunks((int)speciesNum, (int)numberOfResources);
        this.jobManager.setNumberOfNodes(chunkSizes.length);
        ArrayList<String> arguments = new ArrayList<String>();
        int order = speciesOffset;
        for (int i = 0; i < chunkSizes.length; ++i) {
            String argumentString = "0_" + geoNum + "_" + order + "_" + chunkSizes[i] + "_./";
            arguments.add(argumentString);
            order += chunkSizes[i];
            AnalysisLogger.getLogger().debug((Object)("D4ScienceGenerator-> Argument " + i + ": " + argumentString));
        }
        String owner = this.config.getParam("ServiceUserName");
        if (owner == null) {
            throw new Exception("Null Owner");
        }
        String pathToDir = this.config.getPersistencePath() + this.config.getModel();
        if (!new File(pathToDir).exists()) {
            throw new Exception("No Implementation of node-model found for algorithm " + pathToDir);
        }
        if (this.mainclass == null) {
            throw new Exception("No mainClass found for algorithm " + pathToDir);
        }
        this.buildScriptFile(this.config.getModel(), defaultJobOutput, pathToDir, this.mainclass);
        this.jobManager.uploadAndExecute(AlgorithmConfiguration.StatisticalManagerClass, AlgorithmConfiguration.StatisticalManagerService, owner, pathToDir, "/" + this.config.getModel() + "/", "./", defaultScriptFile, arguments, deletefiles);
    }

    public void buildScriptFile(String jobName, String jobOutput, String jarsPath, String fullMainClass) throws Exception {
        File[] files;
        StringBuffer sb = new StringBuffer();
        sb.append("#!/bin/sh\n");
        sb.append("# " + jobName + "\n");
        sb.append("cd $1\n");
        sb.append("\n");
        sb.append("java -Xmx1024M -classpath ./:");
        File jarsPathF = new File(jarsPath);
        for (File jar : files = jarsPathF.listFiles()) {
            if (!jar.getName().endsWith(".jar")) continue;
            sb.append("./" + jar.getName());
            sb.append(":");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" " + fullMainClass + " $2 " + jobOutput);
        sb.append("\n");
        AnalysisLogger.getLogger().trace((Object)("D4ScienceGenerator->Generating script in " + new File(jarsPath, defaultScriptFile).getAbsolutePath()));
        FileTools.saveString((String)new File(jarsPath, defaultScriptFile).getAbsolutePath(), (String)sb.toString(), (boolean)true, (String)"UTF-8");
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> distributionModelParams = new ArrayList<StatisticalType>();
        distributionModelParams.add((StatisticalType)new ServiceType(ServiceParameters.EPR_LIST, "EPRLIST", "List of workers ep", "", true));
        return distributionModelParams;
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            int activeNodes = this.jobManager.getActiveNodes();
            for (int i = 0; i < this.jobManager.getNumberOfNodes(); ++i) {
                try {
                    double value = i < activeNodes ? 100.0 : 0.0;
                    res.addResource("Worker_" + (i + 1), value);
                    continue;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"D4ScienceGenerator->active nodes not ready");
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon((Object)res.list).replace("resId", "resID");
        }
        return "";
    }

    public float getStatus() {
        try {
            float estimated = 0.0f;
            if (this.speciesBlocksExecuted == 0) {
                int nactiveNodes = this.jobManager.getActiveNodes();
                if (nactiveNodes > 0) {
                    estimated = 50.0f / (float)this.speciesBlocks;
                }
            } else {
                estimated = 100.0f * (float)this.speciesBlocksExecuted / (float)this.speciesBlocks;
            }
            System.out.println("ESTIMATED : " + estimated);
            if (!this.stop) {
                return Math.min(estimated, 95.0f);
            }
            return 100.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public StatisticalType getOutput() {
        return this.distributionModel.getOutput();
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_GEOINFO, ALG_PROPS.SPECIES_VS_CSQUARE_FROM_DATABASE};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }

    public void init() throws Exception {
        Properties p = AlgorithmConfiguration.getProperties((String)(this.config.getConfigPath() + AlgorithmConfiguration.nodeAlgorithmsFile));
        this.mainclass = p.getProperty(this.config.getModel());
        this.distributionModel = (SpatialProbabilityDistributionNode)Class.forName(this.mainclass).newInstance();
        this.distributionModel.setup(this.config);
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public void shutdown() {
        this.stop = true;
        try {
            this.jobManager.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.distributionModel.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLoad() {
        long tk = System.currentTimeMillis();
        int processedSpecies = this.distributionModel.getNumberOfProcessedSpecies();
        ResourceLoad rs = new ResourceLoad(tk, (double)processedSpecies);
        return rs.toString();
    }

    public String getResourceLoad() {
        long thisTime = System.currentTimeMillis();
        int processedRecords = this.distributionModel.getNumberOfProcessedSpecies();
        int estimatedProcessedRecords = 0;
        estimatedProcessedRecords = processedRecords == this.lastProcessed ? Math.round((float)thisTime * (float)this.lastProcessed / (float)this.lastTime) : (this.lastProcessed = processedRecords);
        this.lastTime = thisTime;
        ResourceLoad rs = new ResourceLoad(thisTime, (double)estimatedProcessedRecords);
        return rs.toString();
    }

    public GenericAlgorithm getAlgorithm() {
        return this.distributionModel;
    }

    public String getDescription() {
        return "A Generator on D4Science relying only on Executors";
    }
}

