/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.executor.scripts.GetExecuteScript;

public class LocalJobManager {
    public boolean uploadAndExecute(String scope, String serviceClass, String serviceName, String owner, String localDir, String remoteDir, String outputDir, int numberOfNodes, String script, List<String> arguments) throws Exception {
        boolean executeAll = false;
        ScopeProvider.instance.set(scope);
        IClient client = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED).getClient();
        File dir = new File(localDir);
        File[] files = dir.listFiles();
        long t0 = System.currentTimeMillis();
        System.out.println("Start uploading");
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<String> fileurls = new ArrayList<String>();
        for (File sfile : files) {
            String localf = sfile.getAbsolutePath();
            String filename = sfile.getName();
            String remotef = remoteDir + sfile.getName();
            client.put(true).LFile(localf).RFile(remotef);
            String url = client.getUrl().RFile(remotef);
            System.out.println("URL created: " + url);
            filenames.add(filename);
            fileurls.add(url);
        }
        System.out.println("Upload end");
        System.out.println("Executing script");
        GetExecuteScript scripter = new GetExecuteScript();
        int len = arguments.size();
        for (int i = 0; i < numberOfNodes; ++i) {
            String argum = "";
            if (i < len) {
                argum = arguments.get(i);
            }
            scripter.executeScript(filenames, fileurls, outputDir, script, argum, "" + i, scope, serviceClass, serviceName, owner, remoteDir, null, true);
        }
        List listElements = client.showDir().RDir(remoteDir);
        for (StorageObject obj : listElements) {
            System.out.println("obj stored in directory " + remoteDir + ": " + obj.getName());
        }
        System.out.println("Done in " + (System.currentTimeMillis() - t0) + " ms");
        return executeAll;
    }
}

