/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class TestGetRunningExecutor {
    private static int findNodes(String scopeString) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"*****");
        GCUBEScope scope = GCUBEScope.getScope((String)scopeString);
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "Executor")});
        wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/child::*[local-name()='Task']/name[text()='ExecutorScript']", "ExecutorScript")});
        List listdoc = client.execute((ISQuery)wsquery, scope);
        EndpointReferenceType epr = null;
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        int numberOfEP = 0;
        for (RPDocument resource : listdoc) {
            epr = resource.getEndpoint();
            ++numberOfEP;
            AnalysisLogger.getLogger().debug((Object)("*** " + epr));
            eprs.add(epr);
        }
        AnalysisLogger.getLogger().debug((Object)("Found " + numberOfEP + " endpoints"));
        AnalysisLogger.getLogger().debug((Object)("-> " + eprs));
        return numberOfEP;
    }

    private static int findRunningNodes(String scopeString) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"*****");
        GCUBEScope scope = GCUBEScope.getScope((String)scopeString);
        System.out.println("BROKER:" + ((EndpointReferenceType)scope.getServiceMap().getEndpoints((Object)"MessageBroker").iterator().next()).getAddress().toString());
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "Executor")});
        wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition(" /child::*[local-name()='State']", "RUNNING")});
        List listdoc = client.execute((ISQuery)wsquery, scope);
        EndpointReferenceType epr = null;
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        int numberOfEP = 0;
        for (RPDocument resource : listdoc) {
            epr = resource.getEndpoint();
            ++numberOfEP;
            AnalysisLogger.getLogger().debug((Object)("*** " + epr));
            eprs.add(epr);
        }
        AnalysisLogger.getLogger().debug((Object)("Found " + numberOfEP + " endpoints"));
        AnalysisLogger.getLogger().debug((Object)("-> " + eprs));
        return numberOfEP;
    }

    public static void main(String[] args) throws Exception {
        String scope = "/gcube";
        AnalysisLogger.setLogger((String)"./cfg/ALog.properties");
        TestGetRunningExecutor.findNodes(scope);
    }
}

