package org.gcube.dataanalysis.executor.job.management;

import org.apache.log4j.Logger;
import org.gcube.vremanagement.executor.stubs.TaskProxy;

public class WorkerWatcher {
	private static int maxTries = 15;
	private int currentTries;
	private static String runningState = "RUNNING";
	private static String failedState = "FAILED";
	Logger logger;
	
	TaskProxy proxy;
	public WorkerWatcher(TaskProxy proxy, Logger logger){
		this.proxy = proxy;
		this.logger = logger;
		currentTries = 1;
	}
	
	public String getState(){
		String state ="";
		try{
		proxy.synchronize();
		state = proxy.getState();
		return state;
		}catch(Exception  e){
			logger.error("Error in getting state: recover try number "+currentTries,e);
			currentTries++;
			if (currentTries>maxTries){
				return failedState;
			}
			else return runningState;
		}
		
	}
	
}
