/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DistanceCalculator;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;

public class RealTimeMatcher {
    public String PARSER;
    public String INPUT_DATA_SOURCE_ID;
    public String INPUT_DATA_ID;
    public String INPUT_DATA;
    public String PREPARSED_INPUT_DATA;
    public String PARSED_SCIENTIFIC_NAME;
    public String PARSED_AUTHORITY;
    public String POST_PARSED_SCIENTIFIC_NAME;
    public String POST_PARSED_AUTHORITY;
    static HashMap<String, HashMap<String, TafInfo>> officialTafsMap;
    static int cachCleaningTime;
    static String outputheaders;

    static {
        cachCleaningTime = 0x6DDD00;
        outputheaders = "SOURCE_DATASOURCE_ID;SOURCE_ID;SOURCE_DATA;PRE_PARSED_SOURCE_DATA;PARSED_SCIENTIFIC_NAME;PARSED_AUTHORITY;PARSER;POST_PARSED_SCIENTIFIC_NAME;POST_PARSED_AUTHORITY;MATCHING_SCORE;TARGET_DATA_SOURCE;TARGET_DATA_ID;TARGET_DATA_SCIENTIFIC_NAME;TARGET_DATA_AUTHORITY;TARGET_DATA_KINGDOM;TARGET_DATA_PHYLUM;TARGET_DATA_CLASS;TARGET_DATA_ORDER;TARGET_DATA_FAMILY;TARGET_DATA_GENUS;TARGET_DATA_SPECIES;TARGET_DATA_VERNACULAR_NAMES";
    }

    private HashMap<String, TafInfo> getCurrentTaf(String tafFile) throws Exception {
        try {
            String file = FileTools.loadString((String)tafFile, (String)"UTF-8");
            String[] tafrows = file.split("\n");
            if (officialTafsMap == null) {
                officialTafsMap = new HashMap();
                Timer cachecleaner = new Timer();
                cachecleaner.schedule((TimerTask)new TafsCacheCleaner(), cachCleaningTime);
            }
            if (officialTafsMap.get(tafFile) != null) {
                return officialTafsMap.get(tafFile);
            }
            HashMap<String, TafInfo> tafMap = new HashMap<String, TafInfo>();
            String[] stringArray = tafrows;
            int n = tafrows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                List elements = Transformations.parseCVSString((String)row, (String)"\t");
                TafInfo tafInfo = new TafInfo();
                tafInfo.TARGET_DATA_ID = (String)elements.get(0);
                tafInfo.TARGET_DATA_SCIENTIFIC_NAME = (String)elements.get(37);
                tafInfo.TARGET_DATA_AUTHORITY = (String)elements.get(41);
                tafInfo.TARGET_DATA_KINGDOM = (String)elements.get(1);
                tafInfo.TARGET_DATA_PHYLUM = (String)elements.get(5);
                tafInfo.TARGET_DATA_CLASS = (String)elements.get(9);
                tafInfo.TARGET_DATA_ORDER = (String)elements.get(13);
                tafInfo.TARGET_DATA_FAMILY = (String)elements.get(17);
                tafInfo.TARGET_DATA_GENUS = (String)elements.get(21);
                tafInfo.TARGET_DATA_SPECIES = (String)elements.get(29);
                tafInfo.TARGET_DATA_VERNACULAR_NAMES = "";
                tafMap.put((String.valueOf(tafInfo.TARGET_DATA_SCIENTIFIC_NAME) + " " + tafInfo.TARGET_DATA_AUTHORITY).toLowerCase(), tafInfo);
                ++n2;
            }
            officialTafsMap.put(tafFile, tafMap);
            return tafMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error: could not read Taf file");
        }
    }

    private void getCurrentInput(String postParserFile) throws Exception {
        try {
            String file = FileTools.loadString((String)postParserFile, (String)"UTF-8");
            String row = file.split("\n")[1];
            List elements = Transformations.parseCVSString((String)row, (String)";");
            this.PARSER = (String)elements.get(0);
            this.INPUT_DATA_SOURCE_ID = (String)elements.get(1);
            this.INPUT_DATA_ID = (String)elements.get(2);
            this.INPUT_DATA = (String)elements.get(3);
            this.PREPARSED_INPUT_DATA = (String)elements.get(4);
            this.PARSED_SCIENTIFIC_NAME = (String)elements.get(5);
            this.PARSED_AUTHORITY = (String)elements.get(6);
            this.POST_PARSED_SCIENTIFIC_NAME = (String)elements.get(7);
            this.POST_PARSED_AUTHORITY = (String)elements.get(8);
        }
        catch (Exception e) {
            throw new Exception("Error: could not read post-parsing file");
        }
    }

    public void match(String taffile, String tafName, String postParserFile, String outputFile, double threshold, int maxvalues) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"RealTimeMatcher started with the following parameters: ");
        AnalysisLogger.getLogger().debug((Object)("taffile: " + taffile));
        AnalysisLogger.getLogger().debug((Object)("tafName: " + tafName));
        AnalysisLogger.getLogger().debug((Object)("postParserFile: " + postParserFile));
        AnalysisLogger.getLogger().debug((Object)("outputFile: " + outputFile));
        AnalysisLogger.getLogger().debug((Object)("threshold: " + threshold));
        AnalysisLogger.getLogger().debug((Object)("maxvalues: " + maxvalues));
        long t0 = System.currentTimeMillis();
        this.getCurrentInput(postParserFile);
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().debug((Object)("Current Input rebuilt in " + (t1 - t0)));
        HashMap<String, TafInfo> scientificnames = this.getCurrentTaf(taffile);
        TafInfo info = scientificnames.get((String.valueOf(this.POST_PARSED_SCIENTIFIC_NAME) + " " + this.POST_PARSED_AUTHORITY).toLowerCase());
        long t2 = System.currentTimeMillis();
        AnalysisLogger.getLogger().debug((Object)("TAF rebuilt in " + (t2 - t1)));
        DistanceCalculator dc = new DistanceCalculator();
        ArrayList<TafInfo> bestTafs = new ArrayList<TafInfo>();
        int bestTafList = 0;
        for (TafInfo testInfo : scientificnames.values()) {
            double snameScore = dc.CD(false, this.POST_PARSED_SCIENTIFIC_NAME, testInfo.TARGET_DATA_SCIENTIFIC_NAME, true, false);
            double authScore = 0.5;
            if (this.POST_PARSED_AUTHORITY != null && testInfo.TARGET_DATA_AUTHORITY != null && this.POST_PARSED_AUTHORITY.length() > 0 && testInfo.TARGET_DATA_AUTHORITY.length() > 0) {
                authScore = dc.CD(false, this.POST_PARSED_AUTHORITY, testInfo.TARGET_DATA_AUTHORITY, true, false);
            } else if (this.POST_PARSED_AUTHORITY == null || this.POST_PARSED_AUTHORITY.length() == 0) {
                authScore = 1.0;
            }
            if (!(authScore * snameScore > threshold)) continue;
            testInfo.MATCHING_SCORE = authScore * snameScore;
            this.insertTaf(bestTafs, testInfo, bestTafList);
            ++bestTafList;
        }
        long t3 = System.currentTimeMillis();
        AnalysisLogger.getLogger().debug((Object)("Scientific Names rebuilt in " + (t3 - t2)));
        AnalysisLogger.getLogger().debug((Object)"Results");
        int belements = 0;
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputFile)));
        bw.write(String.valueOf(outputheaders) + "\n");
        for (TafInfo b : bestTafs) {
            AnalysisLogger.getLogger().debug((Object)(String.valueOf(b.TARGET_DATA_SCIENTIFIC_NAME) + " " + b.TARGET_DATA_AUTHORITY + " " + b.MATCHING_SCORE));
            bw.write(String.valueOf(this.q(this.INPUT_DATA_SOURCE_ID)) + ";" + this.q(this.INPUT_DATA_ID) + ";" + this.q(this.INPUT_DATA) + ";" + this.q(this.PREPARSED_INPUT_DATA) + ";" + this.q(this.PARSED_SCIENTIFIC_NAME) + ";" + this.q(this.PARSED_AUTHORITY) + ";" + this.q(this.PARSER) + ";" + this.q(this.POST_PARSED_SCIENTIFIC_NAME) + ";" + this.q(this.POST_PARSED_AUTHORITY) + ";" + MathFunctions.roundDecimal((double)b.MATCHING_SCORE, (int)2) + ";" + this.q(tafName) + ";" + this.q(b.TARGET_DATA_ID) + ";" + this.q(b.TARGET_DATA_SCIENTIFIC_NAME) + ";" + this.q(b.TARGET_DATA_AUTHORITY) + ";" + this.q(b.TARGET_DATA_KINGDOM) + ";" + this.q(b.TARGET_DATA_PHYLUM) + ";" + this.q(b.TARGET_DATA_CLASS) + ";" + this.q(b.TARGET_DATA_ORDER) + ";" + this.q(b.TARGET_DATA_FAMILY) + ";" + this.q(b.TARGET_DATA_GENUS) + ";" + this.q(b.TARGET_DATA_SPECIES) + ";" + this.q(b.TARGET_DATA_VERNACULAR_NAMES) + "\n");
            if (belements > maxvalues) break;
            ++belements;
        }
        bw.close();
    }

    private String q(String in) {
        return "\"" + in + "\"";
    }

    private void insertTaf(List<TafInfo> elements, TafInfo toInsert, int elementsLen) {
        int counter = 0;
        for (TafInfo e : elements) {
            if (e.MATCHING_SCORE < toInsert.MATCHING_SCORE) break;
            ++counter;
        }
        elements.add(counter, toInsert);
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)("./cfg/" + AlgorithmConfiguration.defaultLoggerFile));
        RealTimeMatcher rtm = new RealTimeMatcher();
        rtm.match("./cfg/FISHBASE_taxa.taf", "FISHBASE", "./cfg/outputParserf139084898dc4e4fb2d7a214bb33de25.txt", "./cfg/outtest.txt", 0.1f, 10);
        rtm.match("./cfg/FISHBASE_taxa.taf", "FISHBASE", "./cfg/outputParserf139084898dc4e4fb2d7a214bb33de25.txt", "./cfg/outtest.txt", 0.1f, 10);
    }

    class TafInfo {
        double MATCHING_SCORE;
        String TARGET_DATA_SOURCE;
        String TARGET_DATA_ID;
        String TARGET_DATA_SCIENTIFIC_NAME;
        String TARGET_DATA_AUTHORITY;
        String TARGET_DATA_KINGDOM;
        String TARGET_DATA_PHYLUM;
        String TARGET_DATA_CLASS;
        String TARGET_DATA_ORDER;
        String TARGET_DATA_FAMILY;
        String TARGET_DATA_GENUS;
        String TARGET_DATA_SPECIES;
        String TARGET_DATA_VERNACULAR_NAMES;

        TafInfo() {
        }
    }

    private class TafsCacheCleaner
    extends TimerTask {
        private TafsCacheCleaner() {
        }

        @Override
        public void run() {
            AnalysisLogger.getLogger().debug((Object)"RealTimeMatcher: Cache cleaned");
            officialTafsMap = null;
            System.gc();
        }
    }
}

