/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.user.GeneratorT;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.tests.TestGenerator;

public class TestD4ScienceQueueMultipleMaps {
    static long globalt0 = System.currentTimeMillis();
    static long total = 0L;

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String[] csquareTable = new String[]{"hcaf_d", "hcaf_d_2018_LINEAR_01341919234605", "hcaf_d_2024_LINEAR_11341919235343", "hcaf_d_2030_LINEAR_21341919235554", "hcaf_d_2036_LINEAR_31341919235781", "hcaf_d_2042_LINEAR_41341919235986", "hcaf_d_2050"};
        String[] years = new String[]{"2012", "2018", "2024", "2030", "2036", "2042", "2050"};
        String preprocessedTable = "maxminlat_hspen";
        String envelopeTable = "hspen_mini_10";
        int numberOfResources = 1;
        String userName = "gianpaolo.coro";
        String generatorName = "AQUAMAPS_SUITABLE";
        String scope = "/gcube";
        int k = 2;
        long t0 = System.currentTimeMillis();
        String finalDistributionTable = null;
        for (int i = 0; i < k; ++i) {
            finalDistributionTable = "hspec_suitable_executor_" + years[i];
            System.out.println("Generating hspec " + finalDistributionTable);
            AlgorithmConfiguration config = GeneratorT.getGenerationConfig((int)numberOfResources, (String)generatorName, (String)envelopeTable, (String)preprocessedTable, (String)"", (String)userName, (String)csquareTable[i], (String)finalDistributionTable, (String)configPath);
            config.setPersistencePath("./");
            config.setGcubeScope(scope);
            config.setParam("ServiceUserName", "gianpaolo.coro");
            config.setParam("DatabaseUserName", "utente");
            config.setParam("DatabasePassword", "d4science");
            config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated");
            config.setParam("DatabaseDriver", "org.hibernate.dialect.PostgreSQLDialect");
            config.setTableSpace("tbsp_1");
            TestD4ScienceQueueMultipleMaps testD4ScienceQueueMultipleMaps = new TestD4ScienceQueueMultipleMaps();
            testD4ScienceQueueMultipleMaps.getClass();
            Thread t = new Thread(testD4ScienceQueueMultipleMaps.new ThreadGenerator(config));
            t.start();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("OVERALL LAUNCH TIME COMPUTATION ON " + k + " REQUESTS IS " + (t1 - t0));
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        D4ScienceDistributedProcessing generator = new D4ScienceDistributedProcessing(config);
        generator.init();
        if (generator != null) {
            long t0 = System.currentTimeMillis();
            TestGenerator tgs = new TestGenerator((ComputationalAgent)generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD : " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(10000L);
            }
            System.out.println("FINAL STATUS: " + generator.getStatus() + " ELAPSED " + (System.currentTimeMillis() - t0));
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
        total = System.currentTimeMillis() - globalt0;
        System.err.println("TOTAL TIME: " + total);
    }

    public class ThreadGenerator
    implements Runnable {
        AlgorithmConfiguration c;

        public ThreadGenerator(AlgorithmConfiguration c) {
            this.c = c;
        }

        @Override
        public void run() {
            try {
                TestD4ScienceQueueMultipleMaps.generate(this.c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

