/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.rscripts;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.executor.util.RScriptsManager;

public class SGVMS_Interpolation
extends StandardLocalExternalAlgorithm {
    private static int maxPoints = 10000;
    RScriptsManager scriptmanager;
    String outputFile;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initializing SGVMS_Interpolation");
    }

    public String getDescription() {
        return "An interpolation method relying on the implementation by the Study Group on VMS (SGVMS). The method uses two interpolation approached to simulate vessels points at a certain temporal resolution. The input is a file in TACSAT format uploaded on the Statistical Manager. The output is another TACSAT file containing interpolated points.The underlying R code has been extracted from the SGVM VMSTools framework. This algorithm comes after a feasibility study (http://goo.gl/risQre) which clarifies the features an e-Infrastructure adds to the original scripts. Limitation: the input will be processed up to " + maxPoints + " vessels trajectory points. " + "Credits: Hintzen, N. T., Bastardie, F., Beare, D., Piet, G. J., Ulrich, C., Deporte, N., Egekvist, J., et al. 2012. VMStools: Open-source software for the processing, analysis and visualisation of fisheries logbook and VMS data. Fisheries Research, 115-116: 31-43. " + "Hintzen, N. T., Piet, G. J., and Brunel, T. 2010. Improved estimation of trawling tracks using cubic Hermite spline interpolation of position registration data. Fisheries Research, 101: 108-115. " + "VMStools, available as an add-on package for R. Documentation available at https://code.google.com/p/vmstools/.  " + "Build versions of VMStools for Window, Mac, Linux available at https://docs.google.com/. " + "Authors: Niels T. Hintzen, Doug Beare";
    }

    protected void process() throws Exception {
        this.status = 0.0f;
        this.scriptmanager = new RScriptsManager();
        String scriptName = "interpolateTacsat.r";
        String inputFile = this.config.getParam("InputFile");
        AnalysisLogger.getLogger().debug((Object)("Starting SGVM Interpolation-> Config path " + this.config.getConfigPath() + " Persistence path: " + this.config.getPersistencePath()));
        String defaultInputFileInTheScript = "tacsat.csv";
        String defaultOutputFileInTheScript = "tacsat_interpolated.csv";
        LinkedHashMap<String, String> inputParameters = new LinkedHashMap<String, String>();
        inputParameters.put("npoints", this.config.getParam("npoints"));
        inputParameters.put("interval", this.config.getParam("interval"));
        inputParameters.put("margin", this.config.getParam("margin"));
        inputParameters.put("res", this.config.getParam("res"));
        inputParameters.put("fm", this.config.getParam("fm"));
        inputParameters.put("distscale", this.config.getParam("distscale"));
        inputParameters.put("sigline", this.config.getParam("sigline"));
        inputParameters.put("minspeedThr", this.config.getParam("minspeedThr"));
        inputParameters.put("maxspeedThr", this.config.getParam("maxspeedThr"));
        inputParameters.put("headingAdjustment", this.config.getParam("headingAdjustment"));
        inputParameters.put("equalDist", this.config.getParam("equalDist").toUpperCase());
        inputParameters.put("st", "c(minspeedThr,maxspeedThr)");
        inputParameters.put("fast", "TRUE");
        inputParameters.put("method", "\"" + this.config.getParam("method") + "\"");
        AnalysisLogger.getLogger().debug((Object)("Starting SGVM Interpolation-> Input Parameters: " + inputParameters));
        HashMap<String, String> codeInjection = null;
        boolean scriptMustReturnAFile = true;
        boolean uploadScriptOnTheInfrastructureWorkspace = false;
        AnalysisLogger.getLogger().debug((Object)"SGVM Interpolation-> Executing the script ");
        this.status = 10.0f;
        this.scriptmanager.executeRScript(this.config, scriptName, inputFile, inputParameters, defaultInputFileInTheScript, defaultOutputFileInTheScript, codeInjection, scriptMustReturnAFile, uploadScriptOnTheInfrastructureWorkspace);
        this.outputFile = this.scriptmanager.currentOutputFileName;
        AnalysisLogger.getLogger().debug((Object)("SGVM Interpolation-> Output File is " + this.outputFile));
        this.status = 100.0f;
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, "InputFile", "Input file in TACSAT format. E.g. http://goo.gl/i16kPw"));
        this.addIntegerInput("npoints", "The number of pings or positions required between each real or actual vessel position or ping", "10");
        this.addIntegerInput("interval", "Average time in minutes between two adjacent datapoints", "120");
        this.addIntegerInput("margin", "Maximum deviation from specified interval to find adjacent datapoints (tolerance)", "10");
        this.addIntegerInput("res", "Number of points to use to create interpolation (including start and end point)", "100");
        this.addEnumerateInput(methodEnum.values(), "method", "Set to cHs for cubic Hermite spline or SL for Straight Line interpolation", "cHs");
        this.addDoubleInput("fm", "The FM parameter in cubic interpolation", "0.5");
        this.addIntegerInput("distscale", "The DistScale parameter for cubic interpolation", "20");
        this.addDoubleInput("sigline", "The Sigline parameter in cubic interpolation", "0.2");
        this.addDoubleInput("minspeedThr", "A filter on the minimum speed to take into account for interpolation", "2");
        this.addDoubleInput("maxspeedThr", "A filter on the maximum speed to take into account for interpolation", "6");
        this.addIntegerInput("headingAdjustment", "Parameter to adjust the choice of heading depending on its own or previous point (0 or 1). Set 1 in case the heading at the endpoint does not represent the heading of the arriving vessel to that point but the departing vessel.", "0");
        this.inputs.add(new PrimitiveType(Boolean.class.getName(), null, PrimitiveTypes.BOOLEAN, "equalDist", "Whether the number of positions returned should be equally spaced or not", "true"));
    }

    public StatisticalType getOutput() {
        PrimitiveType o = new PrimitiveType(File.class.getName(), (Object)new File(this.outputFile), PrimitiveTypes.FILE, "OutputFile", "Output file in TACSAT format.");
        return o;
    }

    public void shutdown() {
        if (this.scriptmanager != null) {
            this.scriptmanager.stop();
        }
        System.gc();
    }

    public static enum methodEnum {
        cHs,
        SL;

    }
}

