package org.gcube.dataanalysis.copernicus.motu.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * This class models the current status of an asynchronous download request.
 * 
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class StatusModeResponse {

    /**
     * ???
     */
    private String code;

    /**
     * An optional message received by the server
     */
    private String message;

    /**
     * ???
     */
    private String scriptVersion;

    /**
     * The host originating the request (i.e. the client host).
     */
    private String userHost;

    /**
     * The identity of the user who submitted the request.
     */
    private String userId;

    /**
     * The date when the request was submitted.
     */
    private String dateSubmit;

    /**
     * The path, local to the server, where the response is placed.
     */
    private String localUri;

    /**
     * An URI to be used to download the output dataset.
     */
    private String remoteUri;

    /**
     * The size of the output dataset.
     */
    private String size;

    /**
     * ??? The date when the request was processed ???
     */
    private String dateProc;

    /**
     * An unique, sequential id, assigned to the request.
     */
    private String requestId;

    /**
     * The status of the request (e.g. pending, processing, ready, error).
     */
    private String status;

    @XmlAttribute
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @XmlAttribute(name = "msg")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlAttribute
    public String getScriptVersion() {
        return scriptVersion;
    }

    public void setScriptVersion(String scriptVersion) {
        this.scriptVersion = scriptVersion;
    }

    @XmlAttribute
    public String getUserHost() {
        return userHost;
    }

    public void setUserHost(String userHost) {
        this.userHost = userHost;
    }

    @XmlAttribute
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @XmlAttribute
    public String getDateSubmit() {
        return dateSubmit;
    }

    public void setDateSubmit(String dateSubmit) {
        this.dateSubmit = dateSubmit;
    }

    @XmlAttribute
    public String getLocalUri() {
        return localUri;
    }

    public void setLocalUri(String uri) {
        this.localUri = uri;
    }

    @XmlAttribute
    public String getRemoteUri() {
        return remoteUri;
    }

    public void setRemoteUri(String uri) {
        this.remoteUri = uri;
    }

    @XmlAttribute
    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @XmlAttribute
    public String getDateProc() {
        return dateProc;
    }

    public void setDateProc(String date) {
        this.dateProc = date;
    }

    @XmlAttribute
    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    @XmlAttribute
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isReady() {
        return "1".equals(this.getStatus());
    }

    public boolean isError() {
        return "2".equals(this.getStatus());
    }

    public boolean isInProgress() {
        return "0".equals(this.getStatus()) || "3".equals(this.getStatus());
    }

}
