/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.gcube.dataanalysis.copernicus.motu.client.WorkCompleteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadedWorker<T> {
    private static Logger logger = LoggerFactory.getLogger(ThreadedWorker.class);
    private static final Integer DEFAULT_MAX_THREADS = 2;
    private List<T> workItems = new Vector<T>();
    private Integer maxThreads = DEFAULT_MAX_THREADS;
    private Collection<Runnable> workThreads = new Vector<Runnable>();
    private WorkCompleteListener<T> listener;

    public synchronized void push(T workItem) {
        logger.info("pushing a new chunk");
        this.workItems.add(workItem);
        this.startWorking();
    }

    private synchronized T pop() {
        logger.debug("queue size is " + this.workItems.size());
        if (!this.workItems.isEmpty()) {
            T workItem = this.workItems.get(0);
            this.workItems.remove(workItem);
            return workItem;
        }
        return null;
    }

    private synchronized boolean canStartWorkThread() {
        return this.workThreads.size() < this.getMaxThreads();
    }

    private synchronized void printStatus() {
        int max = this.getMaxThreads();
        int curThreads = this.workThreads.size();
        int waitChunks = this.workItems.size();
        logger.info("Threads:  " + curThreads + "/" + max);
        logger.info("Requests: " + waitChunks + " waiting");
    }

    public synchronized void startWorking() {
        if (this.canStartWorkThread()) {
            final T workItem = this.pop();
            if (workItem == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ThreadedWorker.this.doWork(workItem);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        ThreadedWorker.this.workItemComplete(this, workItem);
                    }
                }
            };
            this.workThreads.add(r);
            new Thread(r).start();
            this.printStatus();
        } else {
            logger.info("maximum number of threads reached. Waiting for one to finish.");
            this.printStatus();
        }
    }

    public abstract void doWork(T var1) throws Exception;

    private synchronized void workItemComplete(Runnable t, T workItem) {
        this.workThreads.remove(t);
        this.startWorking();
        if (this.listener != null) {
            this.listener.workComplete(workItem);
        }
    }

    public synchronized boolean isComplete() {
        return this.workItems.size() == 0 && this.workThreads.size() == 0;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public WorkCompleteListener<T> getListener() {
        return this.listener;
    }

    public void setListener(WorkCompleteListener<T> listener) {
        this.listener = listener;
    }
}

