package org.gcube.dataanalysis.copernicus.cmems.client;

import java.util.Calendar;
import java.util.Collection;
import java.util.TreeSet;

/**
 * @author Paolo Fabriani
 *
 */
public class SearchOptions {

    /**
     * words to match in dataset metadata
     */
    private Collection<String> matchKeys;

    /**
     * words to not match in dataset metadata
     */
    private Collection<String> unmatchKeys;

    /**
     * regional domains to search in
     */
    private Collection<String> regionalDomains;

    /**
     * variables to search for
     */
    private Collection<String> variables;

    /**
     * ignore case in word match
     */
    private boolean ignoreCase;

    /**
     * from date
     */
    private Calendar from;

    /**
     * to date
     */
    private Calendar to;

    private Boolean wholeTimeRange;

    public SearchOptions() {
        this.matchKeys = new TreeSet<>();
        this.unmatchKeys = new TreeSet<>();
        this.regionalDomains = new TreeSet<>();
        this.variables = new TreeSet<>();
        this.ignoreCase = true;
        this.wholeTimeRange = false;
    }

    public Collection<String> getMatchKeys() {
        return matchKeys;
    }

    public void setMatchKeys(Collection<String> matchKeys) {
        this.matchKeys = matchKeys;
    }

    public Collection<String> getUnmatchKeys() {
        return unmatchKeys;
    }

    public void setUnmatchKeys(Collection<String> unmatchKeys) {
        this.unmatchKeys = unmatchKeys;
    }

    public boolean isIgnoreCase() {
        return ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void addMatchedKey(String key) {
        this.matchKeys.add(key);
    }

    public void addUnMatchedKey(String key) {
        this.unmatchKeys.add(key);
    }

    public void addRegionalDomain(String key) {
        this.regionalDomains.add(key);
    }

    public Collection<String> getRegionalDomains() {
        return regionalDomains;
    }

    public void setRegionalDomains(Collection<String> regionalDomains) {
        this.regionalDomains = regionalDomains;
    }

    public void addVariable(String v) {
        this.variables.add(v);
    }

    public Collection<String> getVariables() {
        return variables;
    }

    public void setVariables(Collection<String> variables) {
        this.variables = variables;
    }

    public Calendar getFrom() {
        return from;
    }

    public void setFrom(Calendar from) {
        this.from = from;
    }

    public Calendar getTo() {
        return to;
    }

    public void setTo(Calendar to) {
        this.to = to;
    }

    public Boolean getWholeTimeRange() {
        return wholeTimeRange;
    }

    public void setWholeTimeRange(Boolean wholeTimeRange) {
        this.wholeTimeRange = wholeTimeRange;
    }
}
