/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.gcube.dataanalysis.copernicus.cmems.client.SearchOptions;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsRegion;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsVariable;
import org.gcube.dataanalysis.copernicus.motu.model.MotuServer;
import org.gcube.dataanalysis.datasetimporter.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmemsClient {
    private static Logger LOGGER = LoggerFactory.getLogger(CmemsClient.class);
    private static String CATALOG_URL = "http://cmems-resources.cls.fr/index.php?option=com_csw&task=advancedsearch";
    private static Collection<CmemsProduct> cachedProducts = new Vector<CmemsProduct>();
    private static Long cacheTimestamp;
    private static final Long CACHE_TTL;
    private String endpoint;

    public CmemsClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public CmemsClient() {
        this(CATALOG_URL);
    }

    private Collection<CmemsProduct> downloadProducts() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(new URL(this.endpoint));
        JsonNode docsNode = rootNode.path("products").path("response").path("docs");
        Vector<CmemsProduct> out = new Vector<CmemsProduct>();
        for (CmemsProduct p : (CmemsProduct[])objectMapper.readValue(docsNode.toString(), CmemsProduct[].class)) {
            p.setAbstract(TextUtil.stripHTML((String)p.getAbstract()));
            out.add(p);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CmemsProduct> getAllProducts() throws Exception {
        Collection<CmemsProduct> collection = cachedProducts;
        synchronized (collection) {
            if (this.isCacheExpired().booleanValue()) {
                LOGGER.debug("getting a fresh copy of products");
                Collection<CmemsProduct> prods = this.downloadProducts();
                cachedProducts = prods;
                cacheTimestamp = Calendar.getInstance().getTimeInMillis();
            }
            return cachedProducts;
        }
    }

    private Boolean isCacheExpired() {
        if (cacheTimestamp == null) {
            return true;
        }
        if (Calendar.getInstance().getTimeInMillis() - cacheTimestamp > CACHE_TTL * 60L * 1000L) {
            return true;
        }
        return false;
    }

    public Collection<MotuServer> getMotuServers() throws Exception {
        TreeSet<String> urls = new TreeSet<String>();
        for (CmemsProduct psi : this.getAllProducts()) {
            String tds = psi.getTds();
            if (tds == null || tds.equalsIgnoreCase("undefined")) continue;
            String url = tds.substring(0, tds.indexOf("?"));
            urls.add(url);
        }
        Vector<MotuServer> out = new Vector<MotuServer>();
        for (String url : urls) {
            out.add(new MotuServer(url));
        }
        return out;
    }

    public Collection<CmemsRegion> getRegionalDomains() throws Exception {
        TreeSet<CmemsRegion> out = new TreeSet<CmemsRegion>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] parameters;
            for (String par : parameters = product.getGeographicalArea()) {
                if (par == null || par.trim().isEmpty() || par.trim().equals("undefined")) continue;
                CmemsRegion r = new CmemsRegion();
                r.setName(par.trim());
                out.add(r);
            }
        }
        return out;
    }

    public Collection<CmemsVariable> getOceanVariables() throws Exception {
        TreeSet<CmemsVariable> out = new TreeSet<CmemsVariable>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] parameters;
            for (String par : parameters = product.getOceanVariables()) {
                if (par == null || par.trim().isEmpty() || par.trim().equals("undefined")) continue;
                CmemsVariable r = new CmemsVariable();
                r.setName(par.trim());
                out.add(r);
            }
        }
        return out;
    }

    public Collection<CmemsVariable> getOceanKeys() throws Exception {
        TreeSet<CmemsVariable> out = new TreeSet<CmemsVariable>();
        for (CmemsProduct product : this.getAllProducts()) {
            String[] keys;
            for (String par : keys = product.getOceanKeys()) {
                if (par == null || par.trim().isEmpty() || par.trim().equals("undefined")) continue;
                CmemsVariable r = new CmemsVariable();
                r.setName(par.trim());
                out.add(r);
            }
        }
        return out;
    }

    public Calendar getMinTime() throws Exception {
        Calendar out = Calendar.getInstance();
        for (CmemsProduct product : this.getAllProducts()) {
            Calendar c = product.getTemporalBegin();
            if (!c.before(out)) continue;
            out = c;
        }
        return out;
    }

    public Calendar getMaxTime() throws Exception {
        Calendar out = Calendar.getInstance();
        out.setTimeInMillis(0L);
        for (CmemsProduct product : this.getAllProducts()) {
            Calendar c;
            if (product.getTemporalEnd() == null || !(c = product.getTemporalEnd()).after(out)) continue;
            out = c;
        }
        return out;
    }

    public Collection<CmemsProduct> searchProducts(SearchOptions options) throws Exception {
        Vector<CmemsProduct> output = new Vector<CmemsProduct>();
        for (CmemsProduct product : this.getAllProducts()) {
            if (!this.productMatches(product, options)) continue;
            output.add(product);
        }
        return output;
    }

    private boolean productMatches(CmemsProduct product, SearchOptions options) {
        String t;
        String text = product.getExternalShortname() + " " + product.getAbstract() + " " + product.getShortDescription() + " " + product.getGeographicalArea() + " " + product.getAllKeywords() + " " + product.getOceanVariables() + " " + String.join((CharSequence)" ", product.getOceanKeys()) + " " + String.join((CharSequence)" ", product.getTds());
        if (options.isIgnoreCase()) {
            text = text.toLowerCase();
        }
        for (String k : options.getRegionalDomains()) {
            t = String.join((CharSequence)" ", product.getGeographicalArea());
            if (options.isIgnoreCase()) {
                k = k.toLowerCase();
                t = t.toLowerCase();
            }
            if (t.contains(k)) continue;
            return false;
        }
        for (String k : options.getVariables()) {
            t = String.join((CharSequence)" ", product.getOceanKeys());
            if (options.isIgnoreCase()) {
                k = k.toLowerCase();
                t = t.toLowerCase();
            }
            if (t.contains(k)) continue;
            return false;
        }
        if (options.getFrom() != null) {
            try {
                if (product.getTemporalEnd() != null && product.getTemporalEnd().before(options.getFrom())) {
                    return false;
                }
                if (options.getWholeTimeRange().booleanValue() && product.getTemporalBegin() != null && product.getTemporalBegin().after(options.getFrom())) {
                    return false;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (options.getTo() != null) {
            try {
                if (product.getTemporalBegin() != null && product.getTemporalBegin().after(options.getTo())) {
                    return false;
                }
                if (options.getWholeTimeRange().booleanValue() && product.getTemporalEnd() != null && product.getTemporalEnd().before(options.getTo())) {
                    return false;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        for (String k : options.getMatchKeys()) {
            if (options.isIgnoreCase()) {
                k = k.toLowerCase();
            }
            if (text.contains(k)) continue;
            return false;
        }
        for (String k : options.getUnmatchKeys()) {
            if (options.isIgnoreCase()) {
                k = k.toLowerCase();
            }
            if (!text.contains(k)) continue;
            return false;
        }
        return true;
    }

    static {
        CACHE_TTL = 480L;
    }
}

