/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import org.gcube.dataanalysis.copernicus.motu.client.CASClient;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.MultiValueParameters;
import org.gcube.dataanalysis.copernicus.motu.model.MotuUnmarshaller;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainMotuClient {
    private static Logger logger = LoggerFactory.getLogger(PlainMotuClient.class);
    private String serviceURL;
    private CASClient casProxy;
    private String username;
    private String password;

    public PlainMotuClient(String serviceURL) {
        this.serviceURL = serviceURL;
        this.casProxy = new CASClient();
    }

    public void setUsername(String username) {
        this.username = username;
        this.casProxy.setUsername(username);
    }

    public void setPassword(String password) {
        this.password = password;
        this.casProxy.setPassword(password);
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public StatusModeResponse queueProductDownload(DownloadRequest request) throws Exception {
        request.setAction("productdownload");
        logger.info("queuing request for product download...");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug("status xml is " + xmlStatus);
        return MotuUnmarshaller.getStatusModeResponse(xmlStatus);
    }

    public RequestSize getSize(DownloadRequest request) throws Exception {
        request.setAction("getsize");
        logger.info("requesting response size...");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug("status xml is " + xmlStatus);
        return MotuUnmarshaller.getRequestSize(xmlStatus);
    }

    public ProductMetadataInfo describeProduct(DownloadRequest request) throws Exception {
        request.setAction("describeproduct");
        logger.info("getting product metadata");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlMetadata = NetworkUtils.doGet(url, this.getCasProxy());
        return MotuUnmarshaller.getProductMetadataInfo(xmlMetadata);
    }

    public void describeCoverage(DownloadRequest request) throws Exception {
        request.setAction("describecoverage");
        logger.info("getting product coverage");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap()) + "&datasetID=" + request.getProduct();
        String xmlCoverage = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug("coverage xml is " + xmlCoverage);
    }

    public StatusModeResponse checkStatus(String requestId) throws Exception {
        logger.info("checking status for request " + requestId);
        MultiValueParameters params = new MultiValueParameters();
        params.put("action", "getreqstatus");
        params.put("requestid", requestId);
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(params);
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug("status xml is " + xmlStatus);
        return MotuUnmarshaller.getStatusModeResponse(xmlStatus);
    }

    public StatusModeResponse waitForComplete(String requestId) throws Exception {
        StatusModeResponse statusResponse = null;
        while (true) {
            statusResponse = this.checkStatus(requestId);
            logger.debug(statusResponse.getStatus());
            if (statusResponse.isInProgress()) {
                logger.info("Product is not yet ready. Waiting...");
            } else {
                if (statusResponse.isReady()) {
                    logger.info("Product is ready for download from " + statusResponse.getRemoteUri());
                    break;
                }
                if (statusResponse.isError()) {
                    logger.error(statusResponse.getMessage());
                    break;
                }
            }
            Thread.sleep(20000L);
        }
        return statusResponse;
    }

    public CASClient getCasProxy() {
        return this.casProxy;
    }
}

