package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Calendar;

import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedSubmitter extends ThreadedWorker<DownloadRequestEnvelope> {

    /**
     * A Logger for this class
     */
    private static Logger logger = LoggerFactory.getLogger(ThreadedSubmitter.class);

    /**
     * How often the requests are checked for status update.
     */
    private static final Long CHECK_INTERVAL = 10000l;

    private MotuClient motu;

    public ThreadedSubmitter(MotuClient motu) {
        this.motu = motu;
    }

    public void doWork(DownloadRequestEnvelope chunk) throws Exception {

        // submit
        StatusModeResponse submitStatus = motu.queueProductDownload(chunk);
        chunk.setStart(Calendar.getInstance());
        chunk.setStatus(submitStatus);

        while (true) {

            // check status
            logger.info("checking status of request " + chunk);
            StatusModeResponse checkStatus = motu
                    .checkStatus(chunk.getStatus().getRequestId());

            // error
            if (checkStatus.isError()) {
                if (checkStatus.getMessage().startsWith(
                        "004-1 : Sorry, the system is currently not available. Please try again later")) {
//                    logger.info("unable to get status. Retrying later");
                    this.doWork(chunk);
                    break;
                } else {
                    chunk.setStatus(checkStatus);
                    break;
                }
            }

            // finished; exit
            if (checkStatus.isReady()) {
                logger.info("request " + chunk + " is complete.");
                logger.info("file can be downloaded from "
                        + checkStatus.getRemoteUri());
                chunk.setStatus(checkStatus);
                break;
            }

            // not finished; sleep
            logger.info("waiting a bit...");
            Thread.sleep(CHECK_INTERVAL);
        }

    }

}
