/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class CmemsKeyword implements Comparable<CmemsKeyword> {

    private String name;

    public CmemsKeyword() {
    }

    public CmemsKeyword(String name) {
        super();
        this.name = name;
    }

    @XmlElement
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int compareTo(CmemsKeyword other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(CmemsKeyword other) {
        return this.name.equals(other.name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
