/**
 * 
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/**
 * @author Paolo Fabriani
 *
 */
public class MultiValueParameters {

    private Map<String, Collection<String>> map;

    public MultiValueParameters() {
        this.map = new HashMap<>();
    }

    public void put(String key, String value) {
        Collection<String> coll = this.map.get(key);
        if (coll == null) {
            coll = new Vector<>();
            this.map.put(key, coll);
        }
        coll.add(value);
    }

    public String getFirst(String key) {
        Collection<String> coll = this.map.get(key);
        if (coll == null) {
            return null;
        }
        Iterator<String> iter = coll.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public Collection<String> get(String key) {
        return this.map.get(key);
    }
    
    public Set<String> keySet() {
        return this.map.keySet();
    }
}
