/**
 * 
 */
package org.gcube.dataanalysis.copernicus.motu.model;

import java.util.Collection;
import java.util.Vector;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement(name = "serviceMetadata")
public class ServiceMetadata {

    /**
     * The name of the service.
     */
    private String name;

    /**
     * A description for this service.
     */
    private String description;

    /**
     * The type of the service (e.g. subsetter, dgf, ftp, ...)
     */
    private String type;

    /**
     * Products in this service
     */
    private Collection<ProductMetadataInfo> products;
    
    /**
     * Getter for the name attribute.
     * @return The name of the service.
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        String d = description.replaceAll("&nbsp;", " ");
        this.description = d;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name = "product")
    @XmlElementWrapper(name = "products")
    public Collection<ProductMetadataInfo> getProducts() {
        return products;
    }

    public void setProducts(Collection<ProductMetadataInfo> products) {
        this.products = products;
    }
    
    public void addProduct(ProductMetadataInfo product) {
        if(this.products==null) {
            this.products = new Vector<>();
        }
        this.products.add(product);
    }
    
    public boolean hasProducts() {
        return this.getProducts()!=null && this.getProducts().size()>0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
