/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.client;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.gcube.dataanalysis.copernicus.cmems.client.CmemsClient;
import org.gcube.dataanalysis.copernicus.cmems.client.SearchOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.client.CmemsImporterClient;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.MotuClient;
import org.gcube.dataanalysis.copernicus.motu.model.Axis;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.Variable;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

public class CmemsImporterClientCLI {
    private static Options searchOptions;
    private static Options productOptions;
    private static Options scheduleOptions;
    private static Options unscheduleOptions;
    private static Options listOptions;

    private static void unschedule(CommandLine line) throws Exception {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcube-cmems", unscheduleOptions);
        } else {
            String jobId = null;
            if (!line.hasOption("j")) {
                throw new Exception("missing mandatory jobId");
            }
            jobId = line.getOptionValue("j");
            CmemsImporterClient client = new CmemsImporterClient();
            client.unscheduleTask(jobId);
        }
    }

    private static void list(CommandLine line) throws Exception {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcube-cmems", listOptions);
        } else {
            CmemsImporterClient client = new CmemsImporterClient();
            client.listTasks();
        }
    }

    private static void schedule(CommandLine line) throws Exception {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcube-cmems", scheduleOptions);
        } else {
            ImportOptions options = new ImportOptions();
            if (line.hasOption("tlo")) {
                options.settLo(TimeUtil.toCalendar((String)line.getOptionValue("tlo")));
            }
            if (line.hasOption("thi")) {
                options.settHi(TimeUtil.toCalendar((String)line.getOptionValue("thi")));
            }
            if (line.hasOption("xlo")) {
                options.setxLo(Double.valueOf(Double.parseDouble(line.getOptionValue("xlo"))));
            }
            if (line.hasOption("xhi")) {
                options.setxHi(Double.valueOf(Double.parseDouble(line.getOptionValue("xhi"))));
            }
            if (line.hasOption("ylo")) {
                options.setyLo(Double.valueOf(Double.parseDouble(line.getOptionValue("ylo"))));
            }
            if (line.hasOption("yhi")) {
                options.setyHi(Double.valueOf(Double.parseDouble(line.getOptionValue("yhi"))));
            }
            if (line.hasOption("m")) {
                options.setMotu(line.getOptionValue("m"));
            }
            if (line.hasOption("p")) {
                options.setProduct(line.getOptionValue("p"));
            }
            if (line.hasOption("d")) {
                options.setDataset(line.getOptionValue("d"));
            }
            if (line.hasOption("f")) {
                options.setImportSchedule(line.getOptionValue("f"));
            }
            if (line.hasOption("b")) {
                options.setBackTime(Integer.parseInt(line.getOptionValue("b")));
            }
            if (line.hasOption("s")) {
                String option = line.getOptionValue("s");
                if ("year".equals(option)) {
                    options.setChunkSpan(ChunkTimespan.YEAR);
                } else if ("month".equals(option)) {
                    options.setChunkSpan(ChunkTimespan.MONTH);
                } else if ("day".equals(option)) {
                    options.setChunkSpan(ChunkTimespan.DAY);
                }
            }
            CmemsImporterClient client = new CmemsImporterClient();
            client.scheduleJob(options);
        }
    }

    private static void product(CommandLine line) throws Exception {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcube-cmems", productOptions);
        } else {
            CmemsProduct p = null;
            String dataset = line.getOptionValue("d");
            String product = line.getOptionValue("p");
            String motuServer = line.getOptionValue("m");
            if (motuServer == null || product == null) {
                Collection products;
                SearchOptions so = new SearchOptions();
                so.addMatchedKey(dataset);
                if (product != null && !product.isEmpty()) {
                    so.addMatchedKey(product);
                }
                if ((products = new CmemsClient().searchProducts(so)).size() == 1) {
                    p = (CmemsProduct)products.iterator().next();
                    if (motuServer == null) {
                        motuServer = p.getMotuServer();
                    }
                    if (product == null) {
                        product = p.getExternalShortname();
                    }
                } else {
                    System.err.println("found zero or more than one product... please refine your search");
                    System.exit(1);
                }
            }
            DownloadRequest request = new DownloadRequest();
            request.setService(product + "-TDS");
            request.setProduct(dataset);
            MotuClient mc = new MotuClient(motuServer);
            mc.setUsername(System.getenv().get("CMEMS_USERNAME"));
            mc.setPassword(System.getenv().get("CMEMS_PASSWORD"));
            ProductMetadataInfo pmi = null;
            try {
                pmi = mc.describeProduct(request);
            }
            catch (Exception e) {
                e.printStackTrace();
                request.setService(product);
                pmi = mc.describeProduct(request);
            }
            System.out.println("--- Product info --------------------------------------------------");
            System.out.print(CmemsImporterClientCLI.printProduct(p, 1));
            System.out.println("--- Dataset info --------------------------------------------------");
            System.out.print(CmemsImporterClientCLI.printProduct(pmi, 1));
        }
    }

    private static void search(CommandLine line) throws Exception {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcube-cmems", searchOptions);
        } else {
            SearchOptions options = new SearchOptions();
            if (line.hasOption("i")) {
                options.setIgnoreCase(true);
            }
            if (line.hasOption("k")) {
                for (String k : line.getOptionValues("k")) {
                    options.addMatchedKey(k);
                }
            }
            if (line.hasOption("K")) {
                for (String k : line.getOptionValues("K")) {
                    options.addUnMatchedKey(k);
                }
            }
            if (line.hasOption("r")) {
                for (String r : line.getOptionValues("r")) {
                    options.addRegionalDomain(r);
                }
            }
            if (line.hasOption("v")) {
                for (String v : line.getOptionValues("v")) {
                    options.addVariable(v);
                }
            }
            if (line.hasOption("f")) {
                options.setFrom(TimeUtil.toCalendar((String)line.getOptionValue("f")));
            }
            if (line.hasOption("t")) {
                options.setTo(TimeUtil.toCalendar((String)line.getOptionValue("t")));
            }
            if (line.hasOption("w")) {
                options.setWholeTimeRange(Boolean.valueOf(true));
            }
            Collection products = new CmemsClient().searchProducts(options);
            int i = 1;
            for (CmemsProduct p : products) {
                System.out.println("--- " + i + " ---------------------------------");
                System.out.print(CmemsImporterClientCLI.printProduct(p, 2));
                ++i;
            }
        }
    }

    private static String printProduct(ProductMetadataInfo dataset, int verbosity) {
        StringBuffer out = new StringBuffer();
        out.append(CmemsImporterClientCLI.format("Id", dataset.getId()));
        out.append(CmemsImporterClientCLI.format("Name", dataset.getTitle()));
        Vector<String> vars = new Vector<String>();
        for (Variable v : dataset.getVariables()) {
            String s = v.getName() + ": " + v.getDescription() + ", " + v.getStandardName() + " (" + v.getUnits() + ")";
            vars.add(s);
        }
        out.append(CmemsImporterClientCLI.format("Variables", vars.toArray(new String[vars.size()]), true));
        out.append(CmemsImporterClientCLI.format("Time resolution", dataset.getTimeResolution() + " hours"));
        String tc = String.format("from %s to %s (%s steps)", TimeUtil.toString((Calendar)dataset.getFirstAvailableTimeCode()), TimeUtil.toString((Calendar)dataset.getLastAvailableTimeCode()), dataset.getAvailableTimeCodes().size());
        out.append(CmemsImporterClientCLI.format("Time coverage", tc));
        String dpt = String.format("from %f to %f (%s levels)", dataset.getFirstAvailableDepth(), dataset.getLastAvailableDepth(), dataset.getAvailableDepths().size());
        out.append(CmemsImporterClientCLI.format("Depths", dpt));
        Vector<String> axes = new Vector<String>();
        for (Axis a : dataset.getDataGeospatialCoverage()) {
            String s = String.format("%s (%s) - from %s to %s", a.getName(), a.getUnits(), a.getLower(), a.getUpper());
            axes.add(s);
        }
        out.append(CmemsImporterClientCLI.format("Axes", axes.toArray(new String[axes.size()]), true));
        return out.toString();
    }

    private static String printProduct(CmemsProduct product, int verbosity) {
        StringBuffer out = new StringBuffer();
        String fmt = "%20s: %s\n";
        out.append(String.format(fmt, "Id", product.getId()));
        out.append(String.format(fmt, "Name", product.getExternalShortname()));
        String topLeft = "[" + product.getWest() + ", " + product.getNorth() + "]";
        String bottomRight = "[" + product.getEast() + ", " + product.getSouth() + "]";
        out.append(String.format(fmt, "Geograph. coverage", topLeft + " to " + bottomRight));
        out.append(String.format(fmt, "Area", product.getGeographicalArea()));
        out.append(String.format(fmt, "Observation/models", product.getMissionType()));
        out.append(String.format(fmt, "Product type", String.join((CharSequence)", ", product.getTemporalScale())));
        out.append(String.format(fmt, "Processing lev", product.getProcessingLevel()));
        out.append(CmemsImporterClientCLI.format("Data assimilation", product.getModelAssimilation()));
        out.append(String.format(fmt, "Spatial resolution", product.getSpatialResolutionColumn() + " " + product.getSpatialResolutionColumnUnit() + " x " + product.getSpatialResolutionRow() + " " + product.getSpatialResolutionRowUnit()));
        String vc = String.format("from %s to %s (%s levels)", product.getVerticalMin(), product.getVerticalMax(), product.getVerticalLevels());
        out.append(String.format(fmt, "Vertical coverage", vc));
        out.append(String.format(fmt, "Coord. Ref. Sys", product.getCoordRefSys()));
        out.append(String.format(fmt, "Feature Type", product.getFeatureType()));
        String from = "";
        String to = "";
        try {
            from = TimeUtil.toString((Calendar)product.getTemporalBegin());
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        try {
            to = product.getTemporalEnd() == null ? "present" : TimeUtil.toString((Calendar)product.getTemporalEnd());
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        String tc = String.format("from %s to %s", from, to);
        out.append(String.format(fmt, "Temporal coverage", tc));
        out.append(String.format(fmt, "Temporal resolution", product.getTemporalResolution()));
        out.append(String.format(fmt, "Update frequency", product.getUpdateFrequency()));
        out.append(String.format(fmt, "Production unit", product.getProductionUnit()));
        if (verbosity > 1) {
            out.append(CmemsImporterClientCLI.format("Subsetter server", product.getMotuServer()));
        }
        out.append(String.format(fmt, "Description", product.getShortDescription()));
        out.append(String.format(fmt, "Keywords", product.getAllKeywords()));
        return out.toString();
    }

    private static String format(String key, String[] values, boolean multiline) {
        String fmt = "%20s: %s\n";
        if (values.length == 0) {
            return String.format(fmt, key, "---");
        }
        String js = String.format(",\n%22s", "");
        return String.format(fmt, key, String.join((CharSequence)js, values));
    }

    private static String format(String key, String value) {
        String fmt = "%20s: %s\n";
        if (value == null || value.trim().isEmpty()) {
            return String.format(fmt, key, "---");
        }
        return String.format(fmt, key, value.trim());
    }

    private static void innerMain(String[] args) throws Exception {
        String action = null;
        if (args.length > 0) {
            action = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        } else {
            System.err.println("no action specified");
            System.exit(1);
        }
        System.out.println("action is " + action);
        try {
            DefaultParser parser = new DefaultParser();
            switch (action) {
                case "search": {
                    CmemsImporterClientCLI.search(parser.parse(searchOptions, args));
                    break;
                }
                case "product": {
                    CmemsImporterClientCLI.product(parser.parse(productOptions, args));
                    break;
                }
                case "list-jobs": {
                    CmemsImporterClientCLI.list(parser.parse(listOptions, args));
                    break;
                }
                case "schedule-job": {
                    CmemsImporterClientCLI.schedule(parser.parse(scheduleOptions, args));
                    break;
                }
                case "unschedule-job": {
                    CmemsImporterClientCLI.unschedule(parser.parse(unscheduleOptions, args));
                    break;
                }
                case "job-status": {
                    break;
                }
                default: {
                    throw new ParseException("Unrecognized action: " + action);
                }
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String ags = "search -k GLOBAL_ANALYSIS_FORECAST_PHY_001_024";
        ags = "search -k salinity -k mediterranean -i";
        ags = "search -r black -i";
        ags = "search -v velocity -i";
        ags = "search -k MEDSEA_REANALYSIS_PHYS_006_004";
        ags = "search -r mediterranean -v temperature --from 2010-01-01 --to 2017-12-31 --whole-time-range --ignore-case";
        ags = "product -m http://cmems-med-mfc.eu/motu-web/Motu -d sv03-med-ingv-cur-rean-d -p MEDSEA_REANALYSIS_PHYS_006_004";
        ags = "product -d sv03-med-ingv-cur-rean-d -p MEDSEA_REANALYSIS_PHYS_006_004";
        ags = "product -d sv03-med-ingv-cur-rean-d";
        ags = "product -d bs-ulg-bio-an-fc-d";
        ags = "product -d bs-ulg-nut-an-fc-d";
        ags = "product -d CORIOLIS-GLOBAL-CORA03.2-OBS_FULL_TIME_SERIE";
        ags = "product -d KNMI-GLO-WIND_L3-REP-OBS_QUIKSCAT_SEAWINDS_25_ASC";
        ags = "product -d KNMI-GLO-WIND_L3-REP-OBS_ERS-1_SCAT_25_DES";
        ags = "unschedule-job -j 293847-2349s7df-asdf-234";
        CmemsImporterClientCLI.innerMain(args);
    }

    static {
        Option help = new Option("h", "help", false, "print this message");
        Option containsKey = Option.builder((String)"k").longOpt("key").hasArgs().desc("a key to appear in the dataset metadata").build();
        Option doesNotContainKey = Option.builder((String)"K").longOpt("nokey").hasArgs().desc("a key to not appear in the dataset metadata").build();
        Option regdomain = Option.builder((String)"r").longOpt("regional-domain").hasArg().desc("regional domain").build();
        Option ignoreCase = Option.builder((String)"i").longOpt("ignore-case").hasArg(false).desc("ignore case").build();
        Option count = Option.builder((String)"c").longOpt("count-matches").hasArg(false).desc("count the matching datasets").build();
        Option variable = Option.builder((String)"v").hasArg().longOpt("variable").desc("variable").build();
        Option from = Option.builder((String)"f").hasArg().longOpt("from").desc("from").build();
        Option to = Option.builder((String)"t").hasArg().longOpt("to").desc("to").build();
        Option wholeTimeRange = Option.builder((String)"w").hasArg(false).longOpt("whole-time-range").desc("if set the search results will only show products containing the whole selected time range").build();
        searchOptions = new Options();
        searchOptions.addOption(containsKey);
        searchOptions.addOption(doesNotContainKey);
        searchOptions.addOption(ignoreCase);
        searchOptions.addOption(count);
        searchOptions.addOption(regdomain);
        searchOptions.addOption(variable);
        searchOptions.addOption(from);
        searchOptions.addOption(to);
        searchOptions.addOption(wholeTimeRange);
        searchOptions.addOption(help);
        Option datasetName = Option.builder((String)"d").hasArgs().desc("The name of the dataset").longOpt("dataset").build();
        Option productName = Option.builder((String)"p").hasArgs().desc("The name of the product").longOpt("product").build();
        Option motuServer = Option.builder((String)"m").hasArgs().desc("The endpoint of the motu server").longOpt("motu-server").build();
        productOptions = new Options();
        productOptions.addOption(help);
        productOptions.addOption(datasetName);
        productOptions.addOption(productName);
        productOptions.addOption(motuServer);
        Option check = Option.builder((String)"c").longOpt("check").hasArg(false).desc("Get most relevant info before scheduling a job, without actually submitting it").build();
        Option tlo = Option.builder().longOpt("tlo").hasArg().desc("Low time").build();
        Option thi = Option.builder().longOpt("thi").hasArg().desc("High time").build();
        Option xlo = Option.builder().longOpt("xlo").hasArg().desc("Low longitude").build();
        Option xhi = Option.builder().longOpt("xhi").hasArg().desc("High longitude").build();
        Option ylo = Option.builder().longOpt("ylo").hasArg().desc("Low latitude").build();
        Option yhi = Option.builder().longOpt("yhi").hasArg().desc("High latitude").build();
        Option frequency = Option.builder((String)"f").hasArg().longOpt("import-frequency").build();
        Option back = Option.builder((String)"b").hasArg().longOpt("back-time").build();
        Option chunkSpan = Option.builder((String)"s").hasArg().longOpt("chunk-span").build();
        Option postProcess = Option.builder((String)"p").longOpt("post-process").hasArg().build();
        scheduleOptions = new Options();
        scheduleOptions.addOption(check);
        scheduleOptions.addOption(tlo);
        scheduleOptions.addOption(thi);
        scheduleOptions.addOption(xlo);
        scheduleOptions.addOption(xhi);
        scheduleOptions.addOption(ylo);
        scheduleOptions.addOption(yhi);
        scheduleOptions.addOption(frequency);
        scheduleOptions.addOption(back);
        scheduleOptions.addOption(chunkSpan);
        scheduleOptions.addOption(postProcess);
        scheduleOptions.addOption(datasetName);
        scheduleOptions.addOption(productName);
        scheduleOptions.addOption(motuServer);
        scheduleOptions.addOption(variable);
        scheduleOptions.addOption(help);
        unscheduleOptions = new Options();
        Option jobId = Option.builder((String)"j").hasArg().longOpt("job-id").build();
        unscheduleOptions.addOption(jobId);
        unscheduleOptions.addOption(help);
        listOptions = new Options();
        listOptions.addOption(help);
    }
}

