/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.client;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;

public class CmemsBrowserClient {
    private URL endpoint;
    private static final String CMEMS = "cmems";
    private static final String PRODUCTS = "products";

    public CmemsBrowserClient(URL endpoint) {
        this.endpoint = endpoint;
    }

    public List<CmemsProduct> getProducts() {
        Invocation.Builder ib = this.getBuilderForPath(CMEMS, PRODUCTS);
        return Arrays.asList((Object[])ib.get(CmemsProduct[].class));
    }

    public CmemsProduct getProduct(String name) {
        Invocation.Builder ib = this.getBuilderForPath(CMEMS, PRODUCTS, name);
        return (CmemsProduct)ib.get(CmemsProduct.class);
    }

    private Invocation.Builder getBuilderForPath(String ... coords) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.endpoint.toString());
        for (String c : coords) {
            target = target.path(c);
        }
        String gcubeToken = SecurityTokenProvider.instance.get();
        return target.request(new String[]{"application/xml"}).header("gcube-token", (Object)gcubeToken);
    }
}

