/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

public class ThreddsDatasetChunk {
    private String fileName;
    private static final Pattern p = Pattern.compile("([^-]+)-([0-9]+).*");
    private String name;
    private Calendar start;
    private Calendar updated;
    private ChunkTimespan timeSpan;

    public ThreddsDatasetChunk() {
    }

    public ThreddsDatasetChunk(String fileName) throws ParseException {
        this.fileName = fileName;
        Matcher m = p.matcher(fileName);
        if (!m.matches()) {
            throw new ParseException(fileName, 0);
        }
        this.setChunkStart(TimeUtil.toCalendar((String)m.group(2)));
        Matcher m2 = p.matcher(fileName);
        if (!m2.matches()) {
            throw new ParseException(fileName, 0);
        }
        this.setName(m.group(1));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Calendar getChunkStart() {
        return this.start;
    }

    public void setChunkStart(Calendar start) {
        this.start = start;
    }

    public Calendar getChunkUpdate() {
        return this.updated;
    }

    public Calendar getChunkEnd() {
        switch (this.getTimeSpan()) {
            case MONTH: {
                return TimeUtil.getEndOfMonth((Calendar)this.getChunkStart());
            }
            case YEAR: {
                return TimeUtil.getEndOfYear((Calendar)this.getChunkStart());
            }
        }
        return TimeUtil.getEndOfDay((Calendar)this.getChunkStart());
    }

    public void setChunkUpdate(Calendar updated) {
        this.updated = updated;
    }

    public boolean needsUpdate() {
        return this.getChunkEnd().after(this.getChunkUpdate());
    }

    public String toString() {
        return this.getName() + "\n  Period:  " + TimeUtil.toString((Calendar)this.getChunkStart()) + "  \n  Updated: " + TimeUtil.toString((Calendar)this.getChunkUpdate()) + "  \n  Period:  " + this.getTimeSpan() + "  \n  Update?  " + this.needsUpdate();
    }

    public ChunkTimespan getTimeSpan() {
        if (this.timeSpan != null) {
            return this.timeSpan;
        }
        Matcher m = p.matcher(this.getFileName());
        if (m.matches()) {
            int l = m.group(2).length();
            if (l == 4) {
                return ChunkTimespan.YEAR;
            }
            if (l == 6) {
                return ChunkTimespan.MONTH;
            }
            if (l == 8) {
                return ChunkTimespan.DAY;
            }
        }
        return ChunkTimespan.DAY;
    }

    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return this.getName() + "-" + this.formatDatePart() + ".nc";
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String formatDatePart() {
        String datePart;
        Calendar c = this.getChunkStart();
        switch (this.getTimeSpan()) {
            case YEAR: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy");
                datePart = df.format(c.getTime());
                break;
            }
            case MONTH: {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
                datePart = df.format(c.getTime());
                break;
            }
            default: {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                datePart = df.format(c.getTime());
            }
        }
        return datePart;
    }

    public void setTimeSpan(ChunkTimespan timeSpan) {
        this.timeSpan = timeSpan;
    }
}

