/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsDatasetChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsDataset {
    private static Logger logger = LoggerFactory.getLogger(ThreddsDataset.class);
    private ImportOptions options;
    private Collection<ThreddsDatasetChunk> chunks = new Vector<ThreddsDatasetChunk>();

    public ThreddsDataset() {
    }

    public ThreddsDataset(ImportOptions options) {
        this();
        this.setOptions(options);
        ChunkTimespan chunkSpan = options.getChunkSpan();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(options.gettLo().getTimeInMillis());
        Calendar end = options.gettHi();
        if (end == null) {
            logger.debug("No end time in options. Assuming 'now'");
            end = Calendar.getInstance();
            Integer backTime = options.getBackTime();
            if (backTime != null && backTime > 0) {
                logger.debug("End time set back by " + backTime + " days");
                end.add(6, -backTime.intValue());
            }
        }
        while (!c.after(end)) {
            ThreddsDatasetChunk chunk = new ThreddsDatasetChunk();
            Calendar startc = Calendar.getInstance();
            startc.setTimeInMillis(c.getTimeInMillis());
            chunk.setChunkStart(startc);
            chunk.setName(options.getHash());
            chunk.setTimeSpan(chunkSpan);
            logger.debug(chunk.getFileName());
            switch (chunkSpan) {
                case MONTH: {
                    c.add(2, 1);
                    c.set(5, 1);
                    break;
                }
                case YEAR: {
                    c.add(1, 1);
                    c.set(2, 0);
                    c.set(5, 1);
                    break;
                }
                default: {
                    c.add(5, 1);
                }
            }
            this.addChunk(chunk);
        }
    }

    public Collection<ThreddsDatasetChunk> getChunks() {
        if (this.chunks == null) {
            return new Vector<ThreddsDatasetChunk>();
        }
        return this.chunks;
    }

    public void addChunk(ThreddsDatasetChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new Vector<ThreddsDatasetChunk>();
        }
        this.chunks.add(chunk);
    }

    public ImportOptions getRequest() {
        return this.options;
    }

    public void setOptions(ImportOptions request) {
        this.options = request;
    }

    public int size() {
        return this.chunks.size();
    }

    public String toString() {
        String out = "";
        for (ThreddsDatasetChunk c : this.getChunks()) {
            out = out + c.toString() + "\n";
        }
        return out;
    }

    public String getHash() {
        return this.options.getHash();
    }

    public String generateNCML() {
        StringBuffer out = new StringBuffer();
        out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.append("<netcdf xmlns=\"http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2\">\n");
        out.append("  <!--\n");
        for (Map.Entry entry : this.getRequest().toMap().entrySet()) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (v == null) continue;
            out.append(String.format("    %s: %s;\n", k, v));
        }
        out.append("  -->\n");
        out.append("  <attribute name=\"title\" value=\"some title\"/>\n");
        out.append("  <aggregation type=\"joinExisting\" dimName=\"time\">\n");
        for (ThreddsDatasetChunk c : this.getChunks()) {
            this.options.getChunkSpan();
            out.append("    <netcdf location=\"" + this.formatChunkName(c) + "\"/>\n");
        }
        out.append("  </aggregation>\n");
        out.append("</netcdf>\n");
        return out.toString();
    }

    private String formatDatePart(Calendar c) {
        String datePart;
        switch (this.options.getChunkSpan()) {
            case YEAR: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy");
                datePart = df.format(c.getTime());
                break;
            }
            case MONTH: {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
                datePart = df.format(c.getTime());
                break;
            }
            default: {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                datePart = df.format(c.getTime());
            }
        }
        return datePart;
    }

    private String formatChunkName(ThreddsDatasetChunk chunk) {
        return String.format("%s-%s.nc", this.getHash(), this.formatDatePart(chunk.getChunkStart()));
    }

    public boolean contains(ThreddsDatasetChunk chunk) {
        for (ThreddsDatasetChunk c : this.getChunks()) {
            if (!c.getFileName().equals(chunk.getFileName())) continue;
            return true;
        }
        return false;
    }
}

