/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDocument;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Paolo Fabriani
 *
 */
public class ProductResource extends AbstractImporterResource {

    private static Logger logger = LoggerFactory.getLogger(ProductResource.class);
    
    private String productId;
    
    public ProductResource(String id) {
        this.productId = id;
    }
    
    @GET
    public Response getProductResponse() {
        try {
            CmemsProduct p = new DatasetBrowser().getProduct(this.productId);
            if(p!=null) {
                return Response.ok(p).build();
            }
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status(Status.NOT_FOUND).build();                
    }
    
    @GET
    @Path("datasets/tds")
    public Response getTdsDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getTdsDatasets());
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("datasets/tds/{datasetId}")
    public Response getProduct(@PathParam("datasetId")String datasetId) {
        try {
            ProductMetadataInfo pmi = new DatasetBrowser().getMotuDataset(this.productId, datasetId);
            return Response.ok(pmi).build();
        } catch(Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("datasets/wms")
    public Response getWmsDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getWmsDatasets());
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
    
    @GET
    @Path("datasets/ftp")
    public Response getFtpDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getFtpDatasets());
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }
    
    @GET
    @Path("datasets/dgf")
    public Response getDgfDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getDgfDatasets());
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response buildDatasetsResponse(Collection<CmemsDataset> ds) {
        List<CmemsDataset> datasets = new ArrayList<>(ds);
        GenericEntity<List<CmemsDataset>> entity = new GenericEntity<List<CmemsDataset>>(datasets) {};
        Response response = Response.ok(entity).build();
        return response;
    }
    
    @GET
    @Path("documentation")
    public Response getDocumentation() {
        try {
            List<CmemsDocument> documents = new ArrayList<>(new DatasetBrowser().getProduct(this.productId).getDocumentation());
            GenericEntity<List<CmemsDocument>> entity = new GenericEntity<List<CmemsDocument>>(documents) {};
            Response response = Response.ok(entity).build();
            return response;
        } catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

}
